/**
 * @Author Manas Luktuke
 */
var examStore = Ext.create('Academia.store.examinationcenters.reports.ReportbyStudentStore')
Ext.define('Academia.view.examinationcenters.reports.StudentReportFormGrid', {
    title: getExaminationTranslation('REPORT_BY_STUDENT'),
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studentreportformgrid',
    store: examStore,
    frame: false,
    border: true,
    enableColumnHide: true,
    itemId: 'studentreportformgrid',
    headerFix: {
        headerFix: true,
        portalIdsWithStructure: {
            'examinationreports': 1
        }
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: ['->', {
        xtype: 'button',
        itemId: 'exportLessonPlanReportsId',
        tooltip: getCommonTranslation('EXPORT_REPORT'),
        text: getCommonTranslation('EXPORT_REPORT'),
        disabled: true,
        hidden: true,
        menu: [{
            text: 'Excel',
            itemId: 'excelExportLessionPlansBtn'
        }, {
            text: 'Pdf',
            itemId: 'pdfExportLessionPlansBtn'
        }]
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: examStore,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('USER_ID_HEADER'),
        dataIndex: 'userId',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('USER_TYPE'),
        text: 'User Type',
        dataIndex: 'userType',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('ADMISSION_CODE'),
        text: 'Roll Number',
        dataIndex: 'studentCode',
        hidden: false,
        sortable: true,
        flex: 1,
        renderer: function (value, meta, record) {
            if (value != null) {
                return '<a href=#>' + value + '<a>';
            } else {
                return ""
            }
        }
    }, {
        header: getCommonTranslation('USER_STATUS'),
        text: 'User Status',
        dataIndex: 'userStatus',
        hidden: true,
        sortable: true,
        flex: 1,
        renderer: function (value, meta, record) {
            if (value) {
                return '<span style="color: green;">' + "Active" + '</span>';
            } else {
                return '<span style="color: red;">' + "Inactive" + '</span>';
            }
        }
    }, {
        header: getAdmissionTranslation('ADMISSION_ID'),
        text: 'Admissoin Code',
        dataIndex: 'admissionCode',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT'),
        text: 'Student',
        dataIndex: 'studentName',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('FIRST_NAME'),
        text: 'First Name',
        dataIndex: 'firstName',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('MIDDLE_NAME'),
        text: 'Middle Name',
        dataIndex: 'middleName',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('LAST_NAME'),
        text: 'Last Name',
        dataIndex: 'lastName',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('PROGRAM'),
        text: 'Program',
        dataIndex: 'program',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('BATCH'),
        text: 'Batch',
        dataIndex: 'batch',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD'),
        text: 'Period',
        dataIndex: 'period',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('SECTION'),
        text: 'Section',
        dataIndex: 'section',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('COURSE'),
        text: 'Course',
        dataIndex: 'course',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_VARIANT'),
        text: 'Course Variant',
        dataIndex: 'courseVariant',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_PLAN_NUMBER'),
        text: 'Assessment Scheme',
        dataIndex: 'evaluationPlan',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_TYPE'),
        text: 'Assessment Type',
        dataIndex: 'evaluationType',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('ASSESSMENT_SUB_TYPE'),
        text: 'Assessment Sub Type',
        dataIndex: 'evaluationSubType',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('ASSESSMENT_METHOD'),
        text: 'Assessment Method',
        dataIndex: 'evaluationMethod',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('EVENT'),
        text: 'Event',
        dataIndex: 'event',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('FINAL_MARKS'),
        text: 'Final Marks',
        dataIndex: 'finalMarks',
        hidden: false,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('MARK_ENTRY_COUNT'),
        text: 'No. of Mark Entry',
        dataIndex: 'markEntryCount',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('PERSON_ID'),
        text: 'Person ID',
        dataIndex: 'personId',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('SEATCONFIG_ID'),
        text: 'Seat Config ID',
        dataIndex: 'seatConfigId',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('STUDENTID'),
        text: 'Student ID',
        dataIndex: 'studentId',
        hidden: true,
        sortable: true,
        flex: 1
    }, {
        header: getCommonTranslation('ADMISSION_ID'),
        text: 'Admissoin ID',
        dataIndex: 'admissionId',
        hidden: true,
        sortable: true,
        flex: 1,
        renderer: function (value, meta, record) {
            if (value != null) {
                return value;
            } else {
                return ""
            }
        }
    }]
});
