/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.reports.SubjectLevelRemarkReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.subjectlevelremarkreportgrid',
	store :  'examinationcenters.reports.SubjectLevelRemarkReportStore',
	title : getExaminationTranslation('SUBJECT_LEVEL_REMARK_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.SubjectLevelRemarkReportStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
	columns: [
	{
		header : getEnquiryTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1,
		sortable:true
	},{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex : 1,
        sortable:true
    },{
        header: getExaminationTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex : 1,
        sortable: true,
    },{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex : 1,
        sortable: true
    },{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden :true
	},{
		header : getAdmissionTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable:true
	},{
		header : getAdmissionTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable:true
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable:true
	},{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1,
		sortable:true
	},{
		header : getExaminationTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1,
		sortable:true
	},{
		header : getExaminationTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1,
		sortable:true
	},{
		header :getExaminationTranslation('LEVEL_NAME'),
		dataIndex : 'levelName',
		flex : 1,
		sortable:true
	},{
		header : getExaminationTranslation('REMARK'), 
		dataIndex : 'remark',
		flex : 1,
		sortable:true,
	},{
		header : getExaminationTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable:true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			return val;
    		} else {
    			return '-';
    		}
    	},
	},{
		header : getProgramandcourseTranslation('FACULTY_NAME'), 
		dataIndex : 'remarkProvidedBy',
		flex : 1,
		sortable:true,
		hidden :true
	}]
});
