/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */
Ext.define('Academia.view.examinationdegreeremark.DegreeRemarkForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.degreeremarkform',
	autoScroll:true,
	layout: 'vbox',
	method: 'POST',
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'hidden',
		name : 'id'
	},{
		xtype : 'hidden',
		name : 'degreeClassificationId'
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'classificationName',
			itemId: 'classificationName',
			allowBlank : true,
			fieldLabel : getCommonTranslation('DEGREE_CLASSIFICATION_NAME'),
			//fieldLabel : getCommonTranslation('Degree Classification Name'),
//			fieldLabel :'Degree Classification Name',
			readOnly: true
		}, {
			xtype : 'customcombobox',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData'),
			name : 'markingType',
			itemId: 'markingType',
			displayField: 'value',
			valueField: 'id',
            forceSelection:true,
            typeAhead:true,
			allowBlank : false,
			readOnly: true,
			fieldLabel : getCommonTranslation('PROGRAM_MARKING_TYPE'),
			//fieldLabel :getCommonTranslation('Program Marking Type'),
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'numberfield',
			name : 'rangeFrom',
			itemId: 'rangeFrom',
			allowBlank : false,
			fieldLabel : 'Range From',
			allowDecimals: true,
			decimalPrecision: 2,
			minValue: 0,
			maxValue: 99.99
		},{
			xtype : 'numberfield',
			name : 'rangeTo',
			itemId: 'rangeTo',
			allowBlank : false,
			fieldLabel : 'Range To',
			allowDecimals: true,
			decimalPrecision: 2,
			minValue: 0.01,
			maxValue: 100
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 462
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'remark',
			itemId: 'remark', 
			vtype: 'NospaceAsInput',
			allowBlank : false,
			fieldLabel : getCommonTranslation('REMARK'),
			//fieldLabel :getCommonTranslation('Remark'),
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 462
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'recommendation',
			itemId: 'recommendation',
			fieldLabel : getCommonTranslation('RECOMMENDATION_DECISION'),
			//fieldLabel :getCommonTranslation('Recommendation/Decision'),
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 462
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'graphColor',
			itemId: 'graphColor',
			fieldLabel : getCommonTranslation('GRAPH_COLOR'),
			//fieldLabel :getCommonTranslation('Graph Color'),
		}]
	}, {
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'degreeRemarkSubmitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'degreeRemarkCancelBtn',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
});