/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.facilitiesresources.eventAwards.eventAwardsFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.eventawardsfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel panelCls',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
				xtype: 'customcombobox',
				name: 'eventName',
				fieldLabel: getServiceRequestTranslation('EVENT_NAME'),
				itemId:'eventNameId',
				store:'facilitiesresources.resourcebooking.EventNameListStore',
				displayField:'value',
				valueField:'id',
				width:226
			},{
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId:'studentId',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'personId',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
            },{
				xtype: 'customcombobox',
				name: 'activityType',
				fieldLabel: getServiceRequestTranslation('ACTIVITY_TYPE'),
				itemId:'activityTypeId',
				store: 'personinfo.common.pasthistory.ActivityTypeStore',
				displayField:'value',
				valueField:'id',
	            editable: false,
				width:226
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
				xtype: 'datefield',
				name: 'fromDate',
				fieldLabel: getServiceRequestTranslation('FROM_DATE'),
				itemId:'fromDateId',
				width:226,
				endDateField : 'toDateId',
				vtype: 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			},{
				xtype: 'datefield',
				name: 'toDate',
				fieldLabel: getServiceRequestTranslation('TO_DATE'),
				itemId:'toDateId',
				width:226,
				startDateField : 'fromDateId',
				vtype: 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			}]
	 },{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
