/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Resource Calendar Window
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingCalendarWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.resourcebookingcalendarwindow',
			requires: [
						'Ext.picker.Date',
						'Ext.calendar.util.Date',
						'Ext.calendar.CalendarPanel',
						'Ext.calendar.data.MemoryCalendarStore',
						'Ext.calendar.data.MemoryEventStore',
						'Ext.calendar.data.Events',
						'Ext.calendar.data.Calendars',
						'Ext.calendar.form.EventWindow'
		               ],
            modal : true,
   			resizable:false,
   			//autoScroll:true,
   			height:550,
   			border:true,
   			width:'70%',
			title : getCommonTranslation('CALENDAR'),//Calendar
			initComponent: function() {
		        var me = this;
		        me.calendarStore = Ext.create('Ext.calendar.data.MemoryCalendarStore', {
		            data: Ext.calendar.data.Calendars.getData()
		        });
		        me.eventStore = Ext.create('Ext.calendar.data.MemoryEventStore', {});
		        Ext.apply(me, {
		            items: [{
	                    xtype: 'panel',
	                    border: true,
	                    height: 450,
	                    items:[{
							 xtype: 'calendarpanel',
							 itemId : 'viewCalendarId',
							 layout: 'fit',
							 toolBarDateTitleWidth: '70%',
							 border: true,
							 width: '100%',
							 height: '100%',
							 minHeight: 450,
							 padding:0,
		       				 margin:0,
		       				 flex:1,
							 region: 'center',
							 activeItem: 3,
							 eventStore: me.eventStore,//Ext.create('Ext.data.ArrayStore', {}),
							 calendarStore:  me.calendarStore,//Ext.create('Ext.data.ArrayStore', {}),
							 monthViewCfg: {
								 showHeader: true,
								 showWeekLinks: true,
								 showWeekNumbers: true
							 }
						}]
	            	}]
		        });
		                
		        me.callParent(arguments);
		    }
		});
