/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.employeeresourcebookingsearchform',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
    	items:[{
            xtype: 'customcombobox',
            name: 'eventId',
            itemId: 'eventIdItemId',
            fieldLabel: getCommonTranslation('EVENT_NAME'),
            store: 'facilitiesresources.resourcebooking.employeePortal.EmployeeEventNameStore',
            valueField: 'id',
            displayField: 'value',
            queryParam: 'qry',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
        },{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDate',
            vtype: 'daterange',
            endDateField: 'toDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_FROM_DATE'),
            editable: false,
            format: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'fromDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_TO_DATE'),
            editable: false,
            format: CONSTANTS.DATE_FORMAT
        }]
    }, {
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});