Ext.define('Academia.view.facilitiesresources.resourcemaster.HostelTree', {
	 extend: 'Ext.tree.Panel',
	 alias:'widget.hosteltree',
	 itemId:'hosteltree',
	 border: true,
	 autoScroll:true,
	 title:getCommonTranslation('INTERNAL_FACILITIES'), //Internal Facilities and Attached Equipments
	 store:'facilitiesresources.resourcebooking.HostelResourceBookingFormFacilitiesTreeStore',	 	 	 
	 /*
	  * UI Class for the tree without the icons
	  */

	 height: 600,
	 cls: 'no-tree-icon',
	 rootVisible: true,
	 multiSelect: false,
	 singleExpand: false,
	 preserveScrollOnRefresh : true,
	 animate: false,
	 style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM,
	    	width:'100%'
	 },
	 tbar:[{ 
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),  //Edit
	        iconCls:'icon-addbutton',
			 cls:'addbutton'
	    },{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('EDIT'),  //Edit
    	    itemId: 'btnEdit',
    	    iconCls:'icon-editbutton',
			cls:'editbutton'
    	    //text:getCommonTranslation('EDIT') //Edit
    	},{
			xtype : 'button',				
			itemId : 'btnView',
			tooltip : getCommonTranslation('VIEW'),//View
			 iconCls: 'icon-View',
				cls:'iconView'	
			//text : getCommonTranslation('VIEW')  //View
		},{
			xtype : 'button',				
			itemId : 'btnDelete',
			 cls: 'CustomToolbarBtnReject',
			tooltip :getCommonTranslation('DELETE'), //Delete
			   iconCls: 'icon-Delete',
				cls:'iconDelete'
//			text : getCommonTranslation('DELETE') //Delete
		},{
			xtype:'customcombobox',
			itemId:'cmbLocation', 
			fieldLabel:getCommonTranslation('RESOURCE_LOCATION'),
			store:'facilitiesresources.resourcemaster.LocationListStore',
			valueField : 'id',
			displayField : 'value',
			labelWidth: 58,
			width:'22%',
			editable:false,
//			emptyText:getCommonTranslation('SELECT_LOCATION'), //Select Location
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			itemId:'cmbResourceGroup',
			fieldLabel:getCommonTranslation('RESOURCE_GROUP'),
			store:'facilitiesresources.resourcebooking.ResourceGroupStore',
			valueField : 'name',
			displayField : 'value',			
			editable:false,
			width:'22%',
			value:'',
			hidden:true,
//			emptyText:getCommonTranslation('SELECT_RESOURCE_GROUP'), //Select Resource Group
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			itemId:'cmbResourceTypeHosetl',
			fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
//			store:'facilitiesresources.resourcebooking.ResourceTypeStore',
			store:'facilitiesresources.resourcebooking.HostelResourceTypeStore',
			valueField : 'id',
			displayField : 'value',
			width:'22%',
			value:'',
			editable:false,
//			emptyText:getCommonTranslation('SELECT_RESOURCE_TYPE'), //Select Resource Type
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			itemId:'cmbResourceStatus', 
			fieldLabel:getCommonTranslation('RESOURCE_STATUS'),
			store:'facilitiesresources.resourcemaster.ResourceStatusStore',
			valueField : 'value',
			labelWidth: 58,
			displayField : 'name',			
			editable:false,
			width:'22%',
			value:'', 
//			emptyText:getCommonTranslation('SELECT_RESOURCE_STATUS'), //Select Resource Status
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButton',
			buttonAlign : 'left',
//			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]    
});