/**
 *  @priyanshi Sharma
 *  Elections Grid
 */
Ext.define('Academia.view.facultyPortal.Elections.FPElectionsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.fpelectionsgrid',
    title: getHostelTranslation('ELECTIONS_LIST'),
    store: 'election.election.FPElectionGridStore',
    border: true,
    autoScroll: false,
    viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			 store: 'election.election.FPElectionGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
    columns: [{
        header: getCommonTranslation("ELECTION_CODE"),
        dataIndex: 'electionCode',
        sortable: true,
        flex: .2
    },{
        header: getCommonTranslation("ELECTION_NAME"),
        dataIndex: 'electionName',
        sortable:true,
        flex: .2
    },{
        header: getCommonTranslation("ELECTION_TYPE"),
       dataIndex: 'electionType',
        sortable:true,
        flex: .2
    },{
        header: getCommonTranslation("ACADEMIC_TERM"),
        dataIndex: 'academicTerm',
        sortable:true,
        flex: .2
    },{
		header:  getCommonTranslation("VOTING_START_DATE_TIME"),
		dataIndex: 'votingStartDate',
		flex:.2,
		renderer: function(value, metadata, record) {
			var votingtime=  dateRender(value)+ " " + timeRender(record.data.votingStartTime);
			return votingtime;
		}
	},{
		header:  getCommonTranslation("VOTING_END_DATE_TIME"),
		dataIndex: 'votingEndDate',
		flex:.2,
		renderer: function(value, metadata, record) {
			var votingendTime=  dateRender(value)+ " " + timeRender(record.data.votingEndTime);
			return votingendTime;
		}
	},{
        header: getCommonTranslation("VOTING_ACTION"),
        dataIndex: 'votingAction',
        sortable:true,
        flex: .2,
        renderer:function() {
			return  '<a href="#">' +getCommonTranslation("VOTE") +'</a>';
		}
        
    },{
        header: getCommonTranslation("CAPTURED_BY"),
        dataIndex: 'voteCaptureBy',
        sortable:true,
        flex: .2,
        hidden:true,
        renderer:function(value) {
        	if(!isNullOrEmpty(value)){
      		  return  getCommonTranslation(value);
          	} else {
          	  return value;
          	}
          		
  		}
     },{
         header: getCommonTranslation("CAPTURED_ON"),
         dataIndex: 'votedOn',
         sortable:true,
         flex: .2,
         hidden:true,
         renderer:function(value) {
 			return dateRender(value);
 		}
     }]

});