/**
 * @author Akshay Sharma
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.CoursewiseCaptureAttendanceSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursewisecaptureattendancesearch',
	plugins : "formlabelrequired",
	frame: false,
	border:false,
	autoScroll:false,
	method : 'POST',
	cls:'customSearchPanel',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'ACADEMIC_TERM',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariantId',
			itemId : 'courseVariantId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			displayField:'courseVariantCode',
			valueField:'id',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}
		]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'multiselectcombofield',
				addAllSelector: false,
				name: 'timetableSlotList',
				itemId:'timetableSlotListId',
				width: 460,
				labelAlign: 'top',
				fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
				store:Ext.create('Academia.store.attendance.facultyportal.DetailedTimeSlotList'),
				displayField:'value',
				valueField:'id',	
				autoloadStore: false,
				disabled:false,
				typeAhead:false,
				forceSelection:true,
				allowBlank: false,
				hidden:true,
				cls:'multiBrandCampusCls',
				height:'auto',
				listConfig :{         
					listeners :{ 
						beforeshow: function(picker) {
        					picker.width = picker.up('combobox').getSize().width;
        				},
						refresh: function( boundList, eOpts ){
								try{
									var combo = boundList.up('combo');
									var newValue = combo.getValue();
									if(!isNullOrEmpty(newValue[0])){
										var allItems = combo.listKeyNav.boundList.all.elements;
										var selectedDate = '';
										if(typeof combo.getDisplayValue() == "string"){
											selectedDate = combo.getDisplayValue().split(" - ")[0];
										}
										else{
											selectedDate = combo.getDisplayValue()[0].split(" - ")[0];
										}
										var comboDisplayVal = 
										Ext.each(allItems, function(currentItem){
											var currentDate = currentItem.innerText.split(" - ")[0];
											if(findInArray(newValue,currentItem.viewRecordId) || selectedDate == currentDate){
												currentItem.classList.remove("disabledComboItem")
											}
											else{
												currentItem.classList.add("disabledComboItem");
											}
										});
									}
								}
								catch(e){}
						}
					}
				},
				listeners:{
					beforeselect:function(selModel,record,index){
						var combo = selModel.view.field;
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(value[0].data.sessionDate != record.data.sessionDate)
								return false;
						}
					},
					change: function(combo, newValue, oldValue, eOpt){
						var allItems = combo.listKeyNav.boundList.all.elements;
						var selectedDate = '';
						if(typeof combo.getDisplayValue() == "string"){
							selectedDate = combo.getDisplayValue().split(" - ")[0];
						}
						else{
							selectedDate = combo.getDisplayValue()[0].split(" - ")[0];
						}
						var comboDisplayVal = 
						Ext.each(allItems, function(currentItem){
							var currentDate = currentItem.innerText.split(" - ")[0];
							if(findInArray(newValue,currentItem.viewRecordId) || selectedDate == currentDate){
								currentItem.classList.remove("disabledComboItem")
							}
							else{
								currentItem.classList.add("disabledComboItem");
							}
						});
					}
				}}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			items : [{
				xtype: 'multiselectcombofield',
				itemId: 'topicId',
				name: 'topicId',
				width:460,
				fieldLabel: getCommonTranslation('TOPICS'),
				store:Ext.create('Academia.store.attendance.StudentAttendanceTopic'),
				displayField: 'value',
				valueField: 'id',	
				typeAhead:false,
				editable: false,
				forceSelection:true,
				autoSelect: false,
				disabled:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				cls:'ProgramCourseMultiselectField',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			height: 'auto',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('DATE'),
				name : 'dateOfAttendance',
				itemId:'dateOfAttendance_Id',
				maxValue : new Date(),
				vtype : 'daterange',
				allowBlank: false,
				typeAhead:false,
				forceSelection:true,
				hidden:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'calendarSlotList',
				itemId:'calendarSlotListId',
				labelAlign: 'top',
				fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
				store:Ext.create('Academia.store.attendance.facultyportal.CalendarTimeSlotStore'),
				displayField:'value',
				valueField:'id',	
				autoloadStore: false,
				disabled:false,
				typeAhead:true,
				allowBlank: false,
				forceSelection:true,
				hidden:true,
				maxHeight: 150
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'panel',
				itemId:'panelId',
				layout : 'vbox',
				width : 550,
				style:{
					marginLeft:'-10px',
					marginTop:'0px'
				},
				items:[{
					xtype : 'fieldcontainer',
					width: 'auto',
					itemId:'timeContainer',
					name:'timeContainer',
					hidden:true,
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
						xtype : 'timefield',
						name : 'fromTime',		
						itemId : 'fromTime',			
						fieldLabel:getProgramandcourseTranslation('START_TIME'),
						format:'g:i A',
						increment: 1,
						vtype: 'timerange',
						width:100,
						allowBlank:false,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
									obj.nextSibling().setMinValue(sDate);	
								}
							}
						}
					},{
						xtype : 'timefield',
						name : 'toTime',		
						itemId : 'toTime',			
						fieldLabel:getProgramandcourseTranslation('END_TIME'),
						format:'g:i A',
						vtype: 'timerange',
						increment: 1,
						width:100,
						allowBlank:false,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
									obj.previousSibling().setMaxValue(eDate);
								}
							}
						}
					},{
						xtype : 'button',
						itemId: 'timeBtnAdd',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}]
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			style:{
				marginTop:'-30px'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},
			
			{
					xtype: 'button',
					name:'GenrateQR',
				  text:getCommonTranslation('GENERATE_QR'),
					itemId: 'GENRATEQR',
					ui: 'CustomBtnSubmit',
					disabled:true,
					formBind : true,
					scale: CONSTANTS.BUTTONSIZE,
					
					 
				},{
					xtype: 'button',
					text: getCommonTranslation('VIEW_QR'),
					itemId: 'viewQR',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					formBind : true,
					disabled:true,
					hidden: true,
					scale: CONSTANTS.BUTTONSIZE
				},
			
			{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
