/**
 * @author ravindra
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.SessionWiseStudentAttendanceSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.sessionwisestudentattendancesearch',  
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'sessionWiseAcademicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,
	        editable:false,
	        allowBlank:false

		},{
			xtype: 'customcombobox',
			name:'studentName',
			itemId:'sessionWiseStudentId',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore',
			fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
	       	 xtype: 'customcombobox',
	         name: 'sessionwiseStudentStatus',
	         itemId: 'sessionwiseStudentStatusId',
	         fieldLabel: getPersonModuleTranslation('STATUS'),
	         value:true,
	         store: Ext.create('Academia.store.common.StatusComboStore'),
	         valueField: 'value',
	         displayField: 'name',
	         editable:false
	    }]
	}, {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'sessionWiseProgramGroupId',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore'),
			editable: true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			typeAhead:false,

		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'facultyAttendanceProgram',
			itemId : 'sessionWiseAttendanceProgramId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width:460,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			width:226,
			fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
			name:'sessionNo1',
			itemId: 'sessionWiseSessionItemId',
			displayField: 'val',
			valueField: 'code',
			allowBlank:true,
			typeAhead:true,
			value:1,
			queryMode:'local',
			forceSelection:true
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		itemId : 'moreDetailId',
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'startDate',
				itemId:'startDate',
				endDateField : 'endDate',
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},
			{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'endDate',
				itemId : 'endDate',
				startDateField : 'startDate',
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel:getProgramandcourseTranslation('ATTENDANCE_STATUS'),
				itemId:'sessionWiseAttendanceStatus',
				name:'attendanceStatus',
				store:'attendance.StudentAttendanceStatusStore',
				valueField : 'id',
				displayField : 'value'
			},{
				xtype: 'numberfield',
				itemId: 'sessionWiseAbsentForLast',
				name: 'absentForLast',
				fieldLabel:getProgramandcourseTranslation('ABSENT_FOR_CONSECUTIVE_DAYS'),
				mouseWheelEnabled:false,
				hideTrigger:true,
				minValue:0,
				allowDecimals:false,
				enforceMaxLength : true
			}]
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'sessionWiseSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'sessionWiseResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
