/**
 *  @author ravindra
 */
Ext.define('Academia.view.facultyPortal.attendance.StudentAttendanceSummaryGridForFaculty', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentattendancesummarygridforfaculty',
	store :'attendance.facultyportal.StudentAttendanceSummaryReportStore',
	itemId:'studentattendancesummarygridforfacultyId',
	title: getProgramandcourseTranslation('STUDENT_ATTENDANCE_SUMMARY'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},

	dockedItems : [{
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'attendance.facultyportal.StudentAttendanceSummaryReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);
    },
	tbar: [{
		xtype : 'button',
		itemId:'sendSurveyBtn',
		text : getCommonTranslation('SEND_SURVEY'),
		tooltip :getCommonTranslation('SEND_SURVEY')
	},
	{
		xtype : 'button',
		itemId:'summarySendMessageBtn',
		text : getCommonTranslation('SEND_MESSAGE'),
		tooltip :getCommonTranslation('SEND_MESSAGE')
	},{
		xtype : 'button',
		itemId : 'attendanceSummaryReportPrintCertificate',
		tooltip : getCommonTranslation('PRINT_CERTIFICATE'),
		text : getCommonTranslation('PRINT_CERTIFICATE'),
		formBind:true,
	},'->',{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_REPORT'),
		itemId:'exportReport',
		tooltip :getCommonTranslation('EXPORT_REPORT'),
		disabled:true
	}],
	columns: [{
		header :getProgramandcourseTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header :getProgramandcourseTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},{
		header :getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'groupName',
		hidden:true,
		flex : 1
	},{
		header : getProgramandcourseTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getProgramandcourseTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('TOTAL_RECORDS'),
		dataIndex : 'totalRecords',
		flex:1,
		renderer : function(value,records) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getProgramandcourseTranslation('TOTAL_PRESENT'),
		dataIndex : 'presentRecords',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},
	{
		header : getProgramandcourseTranslation('TOTAL_PRESENT_PERCENT'),
		dataIndex : 'presentPercentage',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return value+"%";
			}else{
				return "0%";
			}
		}
	},
	
	{
		header : getProgramandcourseTranslation('TOTAL_ABSENT'),
		dataIndex : 'absentRecords',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},
	{
		header : getProgramandcourseTranslation('TOTAL_ABSENT_PERCENT'),
		dataIndex : 'absentPercentage',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return value+"%";
			}else{
				return "0%";
			}
		}
	}]
});