/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.facultyPortal.masterScheduleFaculty.MasterScheduleFacultySearchFilter',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.masterschedulefacultysearchfilter',
	plugins : "formlabelrequired",
	autoScroll : true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'form',
		itemId:'masterTimeTableFormItemId',
		title : getCommonTranslation('SEARCH'),
		collapsible:true,
		//collapsed:true,		
		frame: true,
		width : '100%',
		items: [{
			xtype : 'hidden',
			name : 'dashletCourseVariantId',
			itemId:'dashletCourseVariantId'
		},{
		        	xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [{
		        		xtype : 'multiselectcombofield',
		        		width: 460,
		        		style:{
		        			marginTop:'5px'
		        		},
		        		name : 'academyLocationMaster',
		        		itemId:'academyLocationMasterId',
		        		fieldLabel : getProgramandcourseTranslation('ALOC'),
		        		store:'course.academyLocation.AcademyLocationByAssign',
		        		allowBlank : true,
		        		valueField : 'id',
		        		maxLength:460,
		        		displayField : 'value'
		        	

		    		}]
		        },
			        {
	            xtype: 'fieldcontainer',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top',
	                width: 226
		            },
	            items: [{
			    	xtype: 'textfield',
			        name: 'masterSectionType',
			        itemId:'masterSectionTypeItemId',
			        hidden:true
		    	},{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name : 'academicTerm',
					itemId : 'academicTerm',
					displayField : 'value',
					valueField : 'id',
					store:'common.AcademicTermStore',
					typeAhead : true,
					forceSelection : true,
					hidden : false,
					width:226
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
					name : 'courseVariant',
					itemId : 'masterCourseVariantId',
					store:Ext.create('Academia.store.course.coursevariants.ParameterCourseVariantStore'),
					displayField : 'courseVariantCode',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true
		},{
                xtype: 'customcombobox',
                name: 'programId',
                itemId: 'masterProgramComboField',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
                //editable: false,
                //allowBlank: true,
                valueField: 'id',
                displayField: 'valueCode',
                triggerAction: 'all',
	    	    queryParam:'name',
	            minChars:3,
	            forceSelection : true,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'+
		                    '</div>';
		                }
		            }
            }]
        },
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
            	xtype: 'customcombobox',
                name: 'batch',
                itemId: 'masterBatch',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
                editable: false,
                disabled :true,
                valueField: 'id',
                displayField: 'value',
                //allowBlank: true,
                /*listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.common.BatchesByProgramId');
                        combo.bindStore(store);
                    }
                }*/
                
            },{
            	xtype: 'customcombobox',
                name: 'period',
                itemId: 'masterPeriod',
                fieldLabel: getPersonModuleTranslation('ATTENDANCE_PERIOD'),
                editable: false,
                valueField: 'id',
                displayField: 'value',
                //allowBlank: true,
                disabled :true,
                store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
                /*listeners: {
                    render: function(combo) {
                        //var store = Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.PeriodSection');
                    	var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                        combo.bindStore(store);
                    }
                }*/
            },{
                xtype: 'customcombobox',
                name: 'section',
                itemId: 'masterSection',
                fieldLabel: getPersonModuleTranslation('SECTION'),
                editable: false,
                valueField: 'id',
				displayField: 'value',
               // allowBlank: true,
                disabled :true,
                store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
                /*listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
                        combo.bindStore(store);
                    }
                }*/
            }]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [{
				xtype : 'button',
				text : getProgramandcourseTranslation('SHOW_CALENDAR'),
				itemId : 'viewCalanderId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				disabled :true
			},{
				xtype : 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetCalanderId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE,
				//formBind : true
			}]
			}
		]
	},{
		xtype:'mastertimetablecalendar',
		itemId: 'mastertimetablecalendarfaculty'
}]
});
