/**
 * @author dharmendra.p
 */
Ext.define('Academia.view.feeandpayment.AccountStatementSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.accountstatementsearch',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls:'customSearchPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		}/*,
		comment due to V2D-42822
		{
			xtype: 'radiogroup',
			itemId:'accountstatementId',
			items:[
			       { boxLabel: getFeeAndPaymentCommonTranslation('STUDENT'), name: 'statementType', inputValue: true,checked:true},
			       { boxLabel: getFeeAndPaymentCommonTranslation('PROGRAM'), name: 'statementType', inputValue: false}
			       ]
		}*/
		// V2D-43903 Start
		,{
			xtype: 'radiogroup',
			itemId:'transactionTypeId',
			name: 'transactionTypeName',
			labelAlign:'top',			
			columns: 2,
			vertical: true,
			items: [
			        { itemId:'actualTransactionId', boxLabel: getFeeAndPaymentCommonTranslation('ACTUAL_TRANSACTION'), name: 'transactionType', inputValue:"ACTUAL_TRANSACTION",checked:true},
			        { itemId:'voucherTransactionId', boxLabel: getFeeAndPaymentCommonTranslation('VOUCHER_BASED_TRANSACTION'), name: 'transactionType', inputValue:"VOUCHER_BASED_TRANSACTION"}
			        ]
		    },
		 // V2D-43903 End 
		    {
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					
				},
				items:[{
		            xtype: 'multiselectcombofield',
		            name: 'academyLocation',
		            itemId: 'academyLocationId',
		            fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		            valueField: 'id',
					displayField: 'value',
					width:700,
					store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
		  			cls:'receiptHeaderMultiselect',
		  			typeAhead: true,
		  			allowBlank:false,
		  			minChars:3,
		            forceSelection: true,
		            listConfig: {
		                listeners: {
		                    beforeshow: function(picker) {
		                        picker.minWidth = picker.up('combobox').getSize().width;
		                    }
		                },
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{code}' +
		                        '</div>';
		                }
		            }
				}]
			},
		    {
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			itemId:'studentwise',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{  
				xtype: 'customcombobox',
				name: 'recieptView',
				itemId:'recieptView',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_FOR'),
				store: 'feeandpayment.dashboardAndReports.FeeFindAllBillTypedUser',
				valueField: 'id',
				displayField: 'code',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.managebill.StudentDetailsByNationalId'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				allowBlank:true,
				queryCaching: false, 
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'sponsors',
				itemId:'sponsors',
				hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
				store: 'feeandpayment.managebill.Sponsors',
				valueField: 'id',
				displayField: 'sponsorName',
				queryParam:'sponsorNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				allowBlank : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{sponsorshipCode}/{sponsorName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
				store: 'feeandpayment.managebill.Applicant',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				forceSelection:true,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				allowBlank : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			},{
                xtype: 'statusAllCombo',
                name: 'STATUS',
                itemId:'statusComboItemId',
                displayField: 'name',
                valueField: 'value',
                value:'Active'
            }]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			itemId:'programwise',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'programCategory',
				ItemId : 'programCategoryId',
				editable: false,
    			autoload: false,
				fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
				//store: 'program.ProgramCategoryStore',
				store:Ext.create('Academia.store.program.ProgramCategoryByProgramId'),
				displayField:'value',
				valueField:'id'
			},{
             	xtype: 'customcombobox',
                name: 'programGroup',
                itemId:'programGroup',
                editable: false,
    			autoload: false,
                fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
                store:Ext.create('Academia.store.program.ProgramGroupByProgramIdStore'),
                displayField:'value',
                valueField:'id'
            },{  
				xtype: 'customcombobox',
				name: 'programName',
				itemId:'programName',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store: 'common.ProgramByApplicantAndStudentStore',
				valueField: 'id',
				displayField: 'valueCode',
				typeAhead:true,
				allowBlank:true,
				forceSelection:true,
				triggerAction: 'all',
				minChars:3,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			itemId:'batchwise',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'batchName',
				itemId:'batchName',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				store: 'feeandpayment.dashboardAndReports.FeeBatchNameByProgramStore',
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				allowBlank:true,
				typeAhead:true,
				forceSelection:true
			},{
    			xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
    			name: 'seatType',
    			itemId: 'seatType',
    			editable: false,
    			autoload: false,
    			store:Ext.create('Academia.store.common.SeatTypesByBatchId'),
    			valueField: 'seatTypeId',
    			displayField: 'seatTypeName',
    			queryMode : 'local'
    		}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_FROM'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_TO'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			},{

				xtype: 'checkboxfield',
				width: 'auto',
				style:{
					marginTop:'25px'
				},
				labelAlign: 'right',
				itemId:'showAllStudentsItemId',
				boxLabel: getFeeAndPaymentCommonTranslation('SHOW_ALL_STUDENTS'),
				name: 'showAllStudents',
				inputValue : true

			},{

              				xtype: 'checkboxfield',
              				width: 'auto',
              				style:{
              					marginTop:'25px'
              				},
              				labelAlign: 'right',
              				itemId:'whetherCancelledTransaction',
              				boxLabel: getFeeAndPaymentCommonTranslation('INCLUDE_ALL_CANCELLED_TRANSACTION'),
              				name: 'includeAllCancelledTransaction',
              				inputValue : true,
              				hidden : true

              			}]
		},{
			xtype: 'panel',
			style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	}, {
		xtype:'fieldcontainer',
		width: '100%',	
		style:{'margin-top':'-3px !important'},
		items:[{
			xtype : 'actualaccountstatementgrid',
			itemId: 'actualaccountstatementId',
		},{
			xtype : 'actualapplicantaccountstatementgrid',
			itemId: 'actualapplicantaccountstatementId',
			hidden:true
		},{
			xtype : 'actualsponsoraccountstatementgrid',
			itemId: 'actualsponsoraccountstatementId',
			hidden:true
		},{
			xtype : 'accountstatementgrid',
			itemId: 'accountstatementgridId',
			hidden:true
		}]
	}]
});