/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.AssociateStudentListForApplicant', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.associatestudentlistforapplicant',
	store : 'feeandpayment.ApplicantForApplicationFeePlan',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_APPLICANT'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.ApplicantForApplicationFeePlan',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	columns: [{
		header : getFeeAndPaymentCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'applicantName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('APPLICANT_ID'),
		dataIndex : 'applicantId',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('STAGE'),
		dataIndex : 'stageName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_SEQUENCE'),
		dataIndex : 'feeRuleDesc',
		flex:1
		/*renderer : function(value){
			if(value==getFeeAndPaymentCommonTranslation('MAPPED')){
				return getCommonTranslation('MAPPED');
			}else if(value==getFeeAndPaymentCommonTranslation('UNMAPPED')){
				return getCommonTranslation('UNMAPPED');
			}
		}*/
	}]
});