/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.FeeAndPaymentDocumentGrid', {
	extend: 'Ext.window.Window',
	alias : 'widget.feeandpaymentdocumentgrid',
	border: true,
	modal : true,
	title: getProgramandcourseTranslation('DOWNLOAD_DOCUMENT'),
	autoScroll: true,
	maxHeight: '20%',
	width: '40%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	items:[{
		xtype: 'form',
		plugins:"formlabelrequired",
		items: [{
			xtype: 'grid',
			itemId:'feeandpaymentdocumentgridId',
			border:true,
			store : 'feeandpayment.FeeAndPaymentDocument',
			tbar: [{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),
				iconCls: 'icon-Delete',
				cls:'iconDelete'		
			}],
			columns :[{
				header : getCommonTranslation('DOCMENT_NAME'),
				dataIndex : 'documentName',
				flex:1,
				renderer:function(value,rec){
					var id=rec.record.data.id;
					if(id!=""&&id!=undefined){
						return '<a href="#">'+value+'</a>';
					}else{
						return value;
					}
				}
			}]
		}]
	}]
});


