/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.PaymentTermConfigureDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.paymenttermconfiguredocumentlistgrid',
	store :'feeandpayment.PaymentTermDocumentListStore',
	border: true,
	autoScroll: true,
	titleAlign:'right',
	cls:'gridDblHorizontalScrollCls',
	frame:false,
	//itemId:'paymentTermConfigureDocumentGridId',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	title : getFeeAndPaymentCommonTranslation('PAYMENT_TERM_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.PaymentTermDocumentListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		this.callParent(arguments);
	},
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	}],
	columns :[{
		header : getCommonTranslation('DOCUMENTS_NAME'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
	}]
});