/**
 *  @author Prakash Soni
 */

Ext.define('Academia.view.feeandpayment.StudentPaymentPlanInstalmentConfigGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentpaymentplaninstalmentconfiggrid',
	store : 'feeandpayment.stoStudentPaymentPlanInstallmentConfig',
	collapsible: true,
	border: true,
	title:getFeeAndPaymentCommonTranslation('INSTALLMENT_CONFIGURATION'),
	cls: 'scheduleInstallmentGridCls',
	autoScroll: true,
//	height:300,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : ['->',{
		xtype: 'button',
		itemId: 'fnpMakePaymentBtn',
		disabled:true,
		text:getFeeAndPaymentCommonTranslation('MAKE_PAYMENT'),
		tooltip: getFeeAndPaymentCommonTranslation('MAKE_PAYMENT')
	},{
		xtype: 'button',
		itemId: 'printVoucherBtn',
		style:{
			marginLeft:'-1px !important'
		},
		disabled:true,
		text:getFeeAndPaymentCommonTranslation('PRINT_VOUCHER'),
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_VOUCHER')
	}],
	columns: [/*
resolved issue 139372{
		hidden:true,
		dataIndex:'id'
	},*/{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_NO'),
		dataIndex: 'sequence',
		align:'center',
		sortable: false,
		flex : .5	  
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALMENT_TYPE'),
		dataIndex : 'amountType',
		sortable: false,
		flex : .5,
		hidden: true,
		renderer:function(value, meta){
			return getCommonTranslation(value);
			}
	},{ 
		header : getFeeAndPaymentCommonTranslation('AMOUNT_TO_BE_PAID'),
		dataIndex : 'amountTobePaid',
		sortable: false,
		flex : .5,	  
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                      
		} 
	},
	{
		header : getFeeAndPaymentCommonTranslation('STATUS'),
		dataIndex : 'status',
		align:'center',
		sortable: false,
		flex : .5,	
		renderer : function(value, metaData, record,
				row, col, store, gridView) {
			if (record.data.status == "Paid") {
				return '<a href="#">' + "Paid" + '</a>';
			} else if (record.data.status == "Not Paid"){
				return '<a href="#">' + "Unpaid" + '</a>';
			}else{
				return 'Pending';
			}
			
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
		dataIndex : 'paymentDate',
		sortable: false,
		flex : .5,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                         
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
		dataIndex : 'schedulePaymentModes',
		sortable: false,
		flex : 1.5,	  
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				var obj = [];
				for(var j=0;j<record.data.schedulePaymentModes.length;j++){
					var mode=record.data.schedulePaymentModes[j];
					if(!isNullOrEmpty(mode.feePaymentMode)){
						obj.push(mode.feePaymentMode.value);
					}else{
						obj.push(mode.data.value);
					}
				}
				return obj;
			}	
		}
	}]
	
});