/**
 * @author Pankaj Sisodiya
 */

Ext.define('Academia.view.feeandpayment.TransferStudentPaymentPlanWin', {
	extend : 'Ext.window.Window',
	alias : 'widget.transferStudentPaymentPlanWin',
	title:getCommonTranslation('Transfer_Student_Payment_Plan'),
	modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    maxHeight : 550,
    items : [{
		xtype:'form',
		plugins : "formlabelrequired",
		items : [ {
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 320
	        },
	        items: [{
				xtype: 'customcombobox',
				name: 'studentPaymentPlan',
				itemId: 'studentPaymentPlan',
				fieldLabel: getCommonTranslation('PAYMENT_PLAN_TO'),
				store:'feeandpayment.StudentPaymentPlanStore',
				displayField:'valueCode',
				valueField:'id',
				typeAhead:true,
				allowBlank:false,
				forceSelection:true,
				hideTrigger:false,	    
				triggerAction: 'all',
				minChars:3,
				queryParam:'query',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{valueCode}' +
						'</div>';
					}
				}
			},{
				xtype: 'datefield',
				name: 'effectiveIntCalDateMonth',
				itemId:'effectiveIntCalDateMonthId',
				fieldLabel: getFeeAndPaymentCommonTranslation('EFFECTIVE_INTEREST_CALCULATION_DATE_MONTH'),
				vtype: 'daterange',
				editable:false,
				width:270,
				disabled:true,
				minValue: Ext.Date.clearTime(new Date(new Date().getFullYear(), new Date().getMonth(), 1)),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 320
			},
			items: [{
				xtype: 'checkboxfield',
				labelAlign: 'right',
				itemId:'copyUnmapedStudent',
				boxLabel: getCommonTranslation('INCLUDE_UNMAPPED_STUDENTS'),
				name: 'copyUnmapedStudent'
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'changeStudentPlanBtn',
				buttonAlign : 'right',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				itemId : 'cancelChangeStudentPlanBtn',
				scale : CONSTANTS.BUTTONSIZE

			} ]
		} ]
	}]
});