/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.accountingconfigurationmappinglist',
	store : 'feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingList',
	title: getCommonTranslation('CONFIGURATION_MAPPING'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingList',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('CONFIGURE_CONTROL_ACCOUNTS'),
			itemId:'configureControlAccountLink',
			listeners : {

			}
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header : getCommonTranslation('IAU'),
		dataIndex : 'iau',
		flex : 1
	},{
		header : getCommonTranslation('ACCOUNT_CONFIGURATION_NAME'),
		dataIndex : 'configurationName',
		flex : 1
	},{
		header : getCommonTranslation('START_DATE'),
		dataIndex : 'startDate',
		flex : 1,
		renderer:function(value){
			return dateRender(value);
		}
	},{
		header : getCommonTranslation('END_DATE'),
		dataIndex : 'endDate',
		flex : 1,
		renderer:function(value){
			return dateRender(value);
		}
	},{
		header : getCommonTranslation('ACCOUNTING_YEAR_TYPE'),
		dataIndex : 'accountingYearType',
		flex : 1
	},{
		header : getCommonTranslation('CURRENT_ACCOUNTING_YEAR'),
		dataIndex : 'currentAccountingYearValue',
		flex : 1

	},{
		header : getCommonTranslation('COMPANY_CODE'),
		dataIndex : 'companyCode',
		flex : 1
	},{
		header : getCommonTranslation('COMPANY_IP'),
		dataIndex : 'companyIp',
		flex : 1
	}]
});
