/**
 *  @author Deepika Parmar
 * 
 */
Ext.define('Academia.view.feeandpayment.coursefeedefinition.FeeHeadConfigurationFilter' ,{
	extend: 'Ext.form.Panel',
	alias : 'widget.feeheadconfigurationfilter',
	autoScroll: true,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	//cls:'customSearchPanel',
	layout:'vbox',
	title:getCommonTranslation('FEE_HEAD_DETAILS'),
	
	items:[{
		xtype: 'hidden',
		name: 'feeDefinitionId',
		itemId : 'feeDefinitionId'
	},{

		xtype: 'hidden',
		name: 'subHeadId',
		itemId : 'subHeadId'
		
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{ xtype: 'customcombobox',
			width: 226,
			name: 'feeheadCourseDepartment',
			itemId:'feeheadCourseDepartmentId',
			store:'department.DepartmentAcademyLocationWiseStore',
			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
			valueField: 'id',
			displayField: 'value',
//			allowBlank: false,
			allowBlank: false,
			typeAhead: false,
			queryParam:'name',
			rowIndx:0,
			minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }},{
			 xtype: 'customcombobox',
				width: 226,
				name: 'feeheadCourseCodeName',
				itemId:'feeheadCourseCodeNameId',
				store:'course.CourseByDepartmentIdStore',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
//				allowBlank: false,
				allowBlank: false,
				typeAhead: false,
				queryParam:'name',
				rowIndx:0,
				minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
		},{
			xtype: 'textfield',
			name: 'feeheadDefinationName',
			itemId:'feeheadDefinationNameId',
			fieldLabel: getCommonTranslation('FEE_DEFINATION_NAME'),
			allowBlank:false,
			maxLength:50

		},{
			xtype: 'customcombobox',
			name: 'feeheadType',
			itemId:'feeheadTypeId',
			hidden:false,
			fieldLabel: getCommonTranslation('FEE_TYPE'),
			store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadCourseFeeTypeStore'),
			valueField: 'id',
			 displayField: 'value',
			forceSelection:true,
			typeAhead:false,
			allowBlank:false
			
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[/*{
			xtype: 'textfield',
			name: 'feeheadDefinationName',
			itemId:'feeheadDefinationNameId',
			fieldLabel: getCommonTranslation('FEE_DEFINATION_NAME'),
			allowBlank:false,
			maxLength:50

		},{
			xtype: 'customcombobox',
			name: 'feeheadType',
			itemId:'feeheadTypeId',
			hidden:false,
			fieldLabel: getCommonTranslation('FEE_TYPE'),
			store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadCourseFeeTypeStore'),
			valueField: 'id',
			 displayField: 'value',
			forceSelection:true,
			typeAhead:false,
			allowBlank:false
			
		},*/
		
		{
		 xtype: 'customcombobox',
		 name: 'academicTerm',
		 itemId: 'academicTermId',
		 fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
		 store : Ext.create('Academia.store.common.AcademicTermStore'),
		 valueField: 'id',
		 displayField: 'value',
		 //queryMode:'local',
		 typeAhead: true,
		 forceSelection: true,
		 allowBlank: true 
		 },{ 
		     xtype : 'datefield',
			 fieldLabel : getCommonTranslation('BILLING_DATE'),
			 name : 'billingDate',
			 itemId:'billingDate', 
			 vtype : 'daterange',
			 minValue : new Date(),
			 allowBlank: true,
			 forceSelection:true,
			 listeners: {
					 render: function(obj) {
					 obj = dateFormatRender(obj); 
					 obj.setValue(new Date());
					 }
				 }
			},{
			xtype: 'customcombobox',
			name: 'feeHead',
			itemId:'feeHeadId',
			fieldLabel: getCommonTranslation('FEE_HEAD'),
			store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadGroupingFeeHeadStore'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			typeAhead:false,
			allowBlank:false
			
		}]
	},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'radiogroup',
				fieldLabel :getCommonTranslation('FEE_DEFINITION_STATUS'),
				itemId: 'feeDefinationStatusId',
				//name:'feeDefinationStatus',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('ACTIVE'), 
					name: 'feeDefinationStatus', 
					itemId: 'feeDefinationActiveStatus',
					inputValue: true,
					checked: true
				},{ 
					boxLabel: getCommonTranslation('INACTIVE'), 
					name: 'feeDefinationStatus', 
					itemId: 'feeDefinationInactiveStatus',
					inputValue:false
				}]
			},{

				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				style:{'margin-top':'27px'},
				itemId:'defaultFeeDefinition',
				boxLabel: getCommonTranslation('DEFAULT_FEE_DEFINITION'),
				name: 'defaultFeeDefinition',
		//		inputValue : true
			
			}]
	},{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('OL_PAYMENT_CONFIG'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '12px!important'},
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
			xtype: 'radiogroup',
			itemId:'whetherOLPaymentAvailableId',
			layout:'hbox',
			fieldLabel:getFeeAndPaymentCommonTranslation('ONLINE_PAYMENT'),
			items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherOLPaymentAvailable', inputValue:true,checked:true},
			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherOLPaymentAvailable', inputValue:false}]
			},{
				xtype: 'radiogroup',
				itemId:'whetherPaymentAtBillLevelId',
				fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_AT_BILL_LEVEL'),
				layout:'hbox',
				items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherPaymentAtBillLevel', inputValue:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherPaymentAtBillLevel', inputValue:false,checked:true}]
			},{
				xtype: 'radiogroup',
				itemId:'whetherPaymentAtBillLevelIdMobile',
				name:'whetherPaymentAtBillLevelMobile',
				fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_AT_BILL_LEVEL_MOBILE'),
				layout:'hbox',
				items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherPaymentAtBillLevelMobile', inputValue:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherPaymentAtBillLevelMobile', inputValue:false,checked:true}]
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'radiogroup',
				itemId:'whetherMandatoryToPayId',
				layout:'hbox',
				fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_MANDATORY'),
				items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherMandatoryToPay', inputValue:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherMandatoryToPay', inputValue:false,checked:true}]
			},{
			xtype: 'radiogroup',
			itemId:'allowPartialPaymentId',
			layout:'hbox',
			fieldLabel:getFeeAndPaymentCommonTranslation('ALLOW_PARTIAL_PAYMENT'),
			items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'allowPartialPayment', inputValue:true},
			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'allowPartialPayment', inputValue:false,checked:true}]
			},{

    			xtype: 'radiogroup',
    			itemId:'allowPartialPaymentMobileAppId',
    			layout:'hbox',
    			width:'100%',
    			fieldLabel:getFeeAndPaymentCommonTranslation('PARTIAL_PAYMENTS_ON_MOBILE_APPLICATION'),
    			items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'allowPartialPaymentMobileApp', inputValue:true},
    			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'allowPartialPaymentMobileApp', inputValue:false,checked:true}]
			}]
		}]
	}]
	
});

