/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.feeandpayment.discounts.AddDiscountStudentParentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.adddiscountstudentparentgrid',
	title: getFeeAndPaymentCommonTranslation('PARENTS_GUARDIAN_LIST'),
	store: 'feeandpayment.discount.AddDiscountStudentParentGridStore',
	border: true,	
    refreshStoreData:true,
    isGridConfigurable: true,
    enableColumnHide: false,
	autoScroll: false,
	//frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		//emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'feeandpayment.discount.AddDiscountStudentParentGridStore',
			//emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('RELATIONSHIP'),
		dataIndex: 'parentRelationship',
		flex:.1,
	    sortable: false/*,
	    renderer:function(value, meta, record){
			if(record.data.isTotalRecord == true ){
				return '<b>'+value+'</b>';
			}else{
				return value;
			}
		}*/
	},{
		header:  getCommonTranslation('PARENT_GUARDIAN_NAME'),
		dataIndex: 'printName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('EMPLOYEE_ID'),
		dataIndex: 'employeeId',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('EMAIL_ADDRESS'),
		dataIndex: 'emailId',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('CONTACT_NO'),
		dataIndex: 'programName',
		flex:.1,
	    sortable: false,
	    renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var code = "";
			var mobileNo = "";
	    	if(!isNullOrEmpty(record.data.code)){
	    		code = record.data.code;
			}
	    	if(!isNullOrEmpty(record.data.mobileNo)){
	    		mobileNo = record.data.mobileNo;
			}
	    	return code+"-"+mobileNo;
		}
	},{
		header:  getCommonTranslation('COLUMN_IS_ALUMNUS'),
		dataIndex: 'isAlumnus',
		flex:.1,
	    sortable: false,
	    hidden: true,
	    renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var isAlumnus = !isNullOrEmpty(record.data.isAlumnus) && record.data.isAlumnus ? 'Yes' : 'No';
	    	return isAlumnus;
		}
	},{
		header:  getCommonTranslation('COLUMN_SCHOOL_ATTENDED'),
		dataIndex: 'schoolAttended',
		flex:.1,
	    sortable: false,
	    hidden: true
	},{
		header: getCommonTranslation('ACTION'),
		dataIndex: 'deleteButton',
		flex:.1,
		style:{'text-align':'center'},
		sortable: false,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			  if(record.data.linkedRecord){
					 var linkBtn ='<button type="button" style="margin-left: 45px !important">' +getCommonTranslation('UNLINK')+'</button>';
					 return linkBtn;
				
				
			}else{
				return '';
			}
		}
	}]
});
