/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.feeandpayment.discounts.AddDiscountStudentSibilingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.adddiscountstudentsibilinggrid',
	title: getFeeAndPaymentCommonTranslation('SIBLING_DISCOUNT'),
	store: 'feeandpayment.discount.AddDiscountStudentSibilingGridStore',
	border: true,
    refreshStoreData:true,
    isGridConfigurable: true,
    enableColumnHide: false,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		//emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.discount.AddDiscountStudentSibilingGridStore',
			//emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('SIBLING_RELATION'),
		dataIndex: 'relationship',
		flex:.1,
	    sortable: false,
	    renderer:function(value, meta, record){
			if(value == 'BROTHER' ){
				return 'Brother';
			}
			if(value == 'SISTER' ){
				return 'Sister';
			}
		}
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.07,
	    sortable: false
	},{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.07,
	    sortable: false
	},{
		header:  getCommonTranslation('DISCOUNT_GIVEN'),
		dataIndex: 'discountType',
		flex:.08,
	    sortable: false
	},{
		header:  getCommonTranslation('PERCENTAGE_AMOUNT'),
		dataIndex: 'discountAmount',
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.discountPercentage)){
				return record.data.discountPercentage+' %';
			}else
			{
				return record.data.discountAmount;
			}
		},
		flex:.13,
	    sortable: false
	},{
		header:  getCommonTranslation('APPLICABLE_FROM'),
		dataIndex: 'applicableFrom',
		renderer:function(value, meta, record){
			return dateRender(value);
		},
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('APPLICABLE_TILL'),
		dataIndex: 'validTill',
		renderer:function(value, meta, record){
			return dateRender(value);
		},
		flex:.07,
	    sortable: false
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'studentDiscountStatus',
		flex:.05,
	    sortable: false,
	    renderer:function(value, meta, record){
			if(value == 'APPLIED' ){
				return 'Pending';
			}
			if(value == 'APPROVED' ){
				return 'Approved';
			}
			if(value == 'REJECTED' ){
				return 'Rejected';
			}
			if(value == 'INACTIVE' ){
				return 'Inactive';
			}
		}
	}]
});
