/**
 *  @author Amit G
 */

Ext.define('Academia.view.feeandpayment.discounts.DiscountMapFeePlanTypeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.discountmapfeeplantypegrid',
	title : getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE'),
	store: 'feeandpayment.discount.DiscountFeePlanTypeMappingListStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	}],
	columns: [{
		header : getCommonTranslation('FEE_PLAN_TYPE'),
		dataIndex : 'feePlanType',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('STAGE_NAME'),
		dataIndex : 'stageName',
		flex : 1	 
	}]
});