/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.discounts.ManageDiscountApplicantList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managediscountapplicantlist',
	store : 'feeandpayment.discount.ManageDiscountListStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	title: getFeeAndPaymentCommonTranslation('MANAGE_DISCOUNT_LIST'),
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.discount.ManageDiscountListStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'discountApproveBtn',
		tooltip: getCommonTranslation('APPROVE'),
		text: getCommonTranslation('APPROVE')
	},{
		xtype: 'button',
		itemId: 'discountRejectBtn',
		tooltip: getCommonTranslation('REJECT'),
		text: getCommonTranslation('REJECT')
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		hidden:true,  //as separating approve and reject buttons V2D-491466
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			/*text:getFeeAndPaymentCommonTranslation('APPROVE_REJECT'),
			tooltip: getFeeAndPaymentCommonTranslation('APPROVE_REJECT'),
			itemId:'btnApproveReject' V2D-491466*/
		}]
	}],
	columns: [{
		header : getCommonTranslation('STUDENT_DISCOUNT_TYPE'),
		dataIndex : 'discountType',
		flex : 1	 
	},{
		header : getCommonTranslation('APPLICANT_ID'),
		dataIndex : 'applicantCode',
		//dataIndex : 'personCode',
		flex : 1
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'applicantName',
		flex : 1
	},{
		header : getCommonTranslation('CURRENCY'),
		dataIndex : 'currency',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				return val;
			} else {
				return '-';
			}
		}
	},{
		header : getCommonTranslation('INTAKE_YEAR'),
		dataIndex : 'intakeYear',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('DISCOUNT_PERCENTAGE_AMOUNT'),
		dataIndex : 'discountPercentage',
		flex : 1.2,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.discountPercentage)){
				return record.data.discountPercentage+' %';
			}else
			{
				return record.data.discountAmount;
			}
		}
	},{
		header : getCommonTranslation('APPLICABLE_FROM'),
		dataIndex : 'applicableFrom',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('Valid_Till'),
		dataIndex : 'validTill',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('APPLIED_DATE'),
		dataIndex : 'appliedDate',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('APPLIED_BY'),
		dataIndex : 'appliedBy',
		flex : 1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'studentDiscountStatus',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				if(val == 'APPLIED'){
					return 'Pending';
				}else{
					return getCommonTranslation(val);
				}
			} else {
				return '-';
			}
		}
	},{
		header : getCommonTranslation('APPROVED_REJECTED_DATE'),
		dataIndex : 'approvedRejectedDate',
		hidden:true,
		flex : 1,
		renderer:function(val1,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val1)) {
				return dateRender(val1);
			} else {
				return '-';
			}
		}
	},{
		header : getCommonTranslation('APPROVED_REJECTED_BY'),
		dataIndex : 'approvedRejectedBy',
		hidden:true,
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				return val;
			} else {
				return '-';
			}
		}
	},{
		header : getCommonTranslation('REMARKS'),
		dataIndex : 'remark',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('SETTLED_DISCOUNT'),
		dataIndex : 'voucherDate',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				return '<a href=#>View</a>';
		}
	},{
		header : getCommonTranslation('ID_TYPE'),
		dataIndex : 'idType',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('AADHAR_CARD_NO'),
		dataIndex : 'aadharCardNo',
		hidden:true,
		flex : 1
	}],
	plugins: [{
	  	  ptype : 'cellediting',
	  	  clicksToEdit: 1
	    }]
});
