/**
 *  @author Amit G
 */

Ext.define('Academia.view.feeandpayment.finance.ManageFinanceMappedProgramGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managefinancemappedprogramgrid',
	store : 'feeandpayment.finance.FinanceHoldPBSFindByGridListing',
	title: getFeeAndPaymentCommonTranslation('MAPPED_PROGRAMS'),
	border: true,
	autoScroll: false,
	frame:false,
	 selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
    selModel: {
		 //showHeaderCheckbox: false,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false
   },
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.finance.FinanceHoldPBSFindByGridListing',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex:1
	}/*,{
		header : getFeeAndPaymentCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	}*/]
});