/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.payment.ManagePaymentForm', {   
	//extend : 'Ext.form.FormPanel',
	extend:'Academia.view.common.IdGeneratorForm',
	formCode:'ManagePaymentForm',
	alias : 'widget.managepaymentform',
	method : 'POST',
	title:getFeeAndPaymentCommonTranslation('PAYMENT_DETAIL'),
	frame:true,
	standardSubmit : false,
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,		
	cls: 'noPaddingPanel',
	width:'100%',
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
    	items:[{
    	
		xtype:'hidden',
		name:'id'
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			cls: 'panelNoSpace'
		},
		items:[{
			xtype:'panel',
			items:[{
				xtype: 'radiogroup',
				labelAlign:'top',
				itemId:'paymentmode',
				cls: 'paymentModeRadioCls',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
				columns: 2,
				flex:1,
				vertical: true,
				items: [
				        { boxLabel: getFeeAndPaymentCommonTranslation('BANK_PAYMENT_LABEL'), name: 'paymentmode', inputValue: 'BANK',checked:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('CASH_PAYMENT_LABEL'), name: 'paymentmode', inputValue: 'CASH'}
				        ]
			}]
		},{
			xtype:'panel',
			items:[{
				xtype: 'radiogroup',
				labelAlign:'top',
				itemId:'paymentType',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_TYPE'),
				columns: 2,
				vertical: true,
				items: [
				        { boxLabel: getFeeAndPaymentCommonTranslation('REGULAR_LABEL'), name: 'paymentType', inputValue: 'REGULAR',checked:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('PDC'), name: 'paymentType', inputValue: 'PDC'}
				        ]
			}]
		}]
	},{
	xtype:'fieldcontainer',
	width: '100%',
	layout : {
		type : 'hbox'
	},
	defaults : {
		width : 226,
		labelAlign : 'top'
	},
	items : [{
        xtype: 'customcombobox',
        name: 'fnpBrandCampusName',
        itemId: 'fnpBrandCampusItemId',
        fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
        valueField: 'id',
		displayField: 'value',
		store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
			width: 460,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		minChars:3,
		queryParam:'qry',
		typeAhead:false,
		hideTrigger:false,
		allowBlank:false,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
		forceSelection:true,
        listConfig: {
            listeners: {
                beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                }
            },
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            getInnerTpl: function() {
                return '<div class="search-item">' +
                    '{code}' +
                    '</div>';
            	}
        	}
		},{
			xtype: 'customcombobox',
			name: 'costCentre',
			itemId:'costCentre',
			fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
			store: 'feeandpayment.receipts.CostCentreReceipt',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			forceSelection:true,
		}]
	},
	{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype:'textfield',
			fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_VOUCHER_NO'),
			itemId:'paymentVoucherNo',
			name:'paymentVoucherNo',
			/*emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			readOnly:true,
			allowBlank:true*/
		},{
			xtype: 'customcombobox',
			name: 'paymentTo',
			itemId:'paymentTo',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_FOR'),
			store: 'feeandpayment.managebill.BillTypeForPayment',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'paymentFor',
			itemId:'paymentFor',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_TO'),
			store: 'feeandpayment.managebill.BillForPayment',
			valueField: 'id',
			displayField: 'value',
			queryMode: 'local',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false
		},{
			xtype: 'checkboxfield',
            name: 'inActiveStudent',
            itemId:'inActiveStudentItemId',
            labelAlign: 'right',
            style:{
            	marginTop:'25px !important'
            },
            boxLabel: getCommonTranslation('INACTIVE_STUDENT'),
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'payingIAU',
			itemId:'payingIAU',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYING_IAU'),
			store: 'feeandpayment.ALUnit',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			allowBlank:true
		},{
			xtype: 'customcombobox',
			name: 'paymentBank',
			itemId:'depositedBankAcount',
			fieldLabel: getFeeAndPaymentCommonTranslation('DEPOSITED_BANK_ACCOUNT'),
			store: 'feeandpayment.receipts.Bank',
			valueField: 'id',
			displayField: 'value',
			hidden:true,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'paymentCash',
			hidden:true,
			itemId:'depositedLedger',
			fieldLabel: getFeeAndPaymentCommonTranslation('DEPOSITED_LEDGER'),
			store: 'feeandpayment.receipts.FeeLedgerName',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype:'datefield',
			fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
			itemId:'transactionDate',
			name:'transactionDate',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
//			value:new Date(),
			allowBlank: false,
			maxValue : new Date(),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'thirdParty',
			itemId:'thirdParty',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTIES'),
			store: 'feeandpayment.managebill.ThirdParties',
			valueField: 'id',
			displayField: 'firstName',
			queryParam:'codeOrPrintName',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{firstName} {lastName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'sponsors',
			itemId:'sponsors',
			hidden:true,
			allowBlank:false,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
			store: 'feeandpayment.managebill.Sponsors',
			valueField: 'id',
			displayField: 'sponsorName',
			queryParam:'sponsorNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{sponsorshipCode}/{sponsorName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
			store: 'feeandpayment.managebill.Applicant',
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'user',
			itemId:'userId',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('USER_OR_NAME'),
			store: 'feeandpayment.managebill.User',
			valueField: 'id',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{nameToBePrinted}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			queryCaching: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'paymentCurrency',
			itemId:'paymentCurrency',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_CURRENCY'),
			labelAlign: 'top',
			store: 'feeandpayment.AcademyCurrency',
			valueField: 'id',
			displayField: 'name',
			queryMode: 'local',	
			typeAhead:true,
			forceSelection:true,
			allowBlank:false,
		},{
			xtype: 'customcombobox',
			name: 'paymentOn',
			itemId:'paymentOn',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_ON'),
			labelAlign: 'top',
			store: 'feeandpayment.PaymentOnStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryMode: 'local',	
			hidden:true,
			typeAhead:true,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{beneficiaryName}/{accountNumber}' +
					'</div>';
				}
			}
		},{
			xtype:'textfield',
			name: 'paymentOnText',
			itemId:'paymentOnText',
			labelSeparator:'',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_ON'),
			hidden:true
		},{
			xtype: 'customcombobox',
			name: 'scholarship',
			itemId:'scholarship',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
			store: 'feeandpayment.managebill.ScholarshipSmartSearch',
			valueField: 'id',
			displayField: 'scholarshipName',
			queryParam:'scholarshipNameOrCode',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{scholarshipCode}/{scholarshipName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
				xtype: 'customcombobox',
				name: 'scholarshipStudent',
				itemId:'scholarshipStudent',
				hidden:true,
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipStudent'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				allowBlank:false,
				queryCaching: false,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'paymentCurrency2',
				itemId:'paymentCurrency2',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_CURRENCY'),
				store: 'feeandpayment.AcademyCurrency',
				valueField: 'id',
				displayField: 'name',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true,
				hidden: true
			}]
		},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		itemId:'addressDetails',
		hidden:true,
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'displayfield',
			name: 'address',
			itemId:'address',
			fieldLabel: getFeeAndPaymentCommonTranslation('ADDRESS')
		},{
			xtype: 'displayfield',
			name: 'emailId',
			itemId:'emailId',
			fieldLabel: getFeeAndPaymentCommonTranslation('EMAIL')
		},{
			xtype:'displayfield',
			fieldLabel:getFeeAndPaymentCommonTranslation('PHONE_NO'),
			itemId:'contactNo',
			name:'contactNo'
		}]
	},{
		xtype:'panel',
		itemId: 'paymentheaderPanel',
		style: {margin:0},
		//style: {marginLeft:'0px',marginTop:'0px',marginRight:'0px',marginBottom:'0px'},
		width: '100%',
		items:[{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: {
				type: 'hbox',
				align: 'bottom'
			},
			items: [{
				xtype: 'customcombobox',
				itemId: 'paymentMode',
				name: 'paymentMode',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
				labelAlign: 'top',
				width: 135,
				store: 'feeandpayment.FeePaymentMode',
				valueField: 'id',
				displayField: 'value',
				 forceSelection:true,
				allowBlank: false
			}, {
				/*xtype: 'numberfield',
				itemId: 'instrumentsNo',
				width: 130,
				fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
				labelAlign: 'top',
				name: 'instrumentsNo',
				allowBlank: false,
				mouseWheelEnabled:false,
				hideTrigger:true,
				minValue:0,
				maxLength: 40,
//   			    enforceMaxLength : true,
				allowDecimals:false*/
				xtype:'textfield',
				enableKeyEvents : true,
				itemId: 'instrumentsNo',
				labelAlign: 'top',
				width: 130,
				name: 'instrumentsNo',
				maxLength: 40,
				allowBlank: false,
				fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
				listeners:{
					keypress : function(e, t){
						try {
							if (window.event) {
								var charCode = window.event.keyCode;
							}else if (e) {
								var charCode = e.which;
							}else { return true; }
							
							if((charCode > 47 && charCode < 58) ||(charCode > 64 && charCode < 91) || (charCode > 96 && charCode < 123))
								{
								
								}

							else{
								return t.preventDefault();
							}
						}
						catch (err) {
							alert(err.Description);
						} 
					}
				}
			},{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
				width: 130,
				itemId:'instrumentDate',
				name:'instrumentDate',
				labelAlign: 'top',
				allowBlank: false,
				//--submitFormat: CONSTANTS.DATE_FORMAT,
			//	value:new Date(),
				maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype:'numberfield',
				name:'amount',
				width: 130,
				allowExponential:true,
				labelAlign: 'top',
				fieldLabel:getFeeAndPaymentCommonTranslation('AMOUNT'),
				itemId:'amount',
				minValue:0,
				maxLength:10,
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowBlank: false
			},{
				xtype: 'customcombobox',
				itemId: 'drawnOnBank',
				width: '31%',
				name: 'drawnOnBank',
				fieldLabel: getFeeAndPaymentCommonTranslation('OUR_BANK_ACCOUNT'),
				labelAlign: 'top',
				store: 'feeandpayment.receipts.DrawnOnBankStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,   
				queryMode: 'local'      	  
			},{
				xtype: 'button',
				itemId: 'btnAddPaymetHeader',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD')
			}] 
		}]
	},{
		xtype:'numberfield',
		labelAlign:'top',
		name:'amount1',
		hidden:true,
		allowExponential:true,
		fieldLabel:getFeeAndPaymentCommonTranslation('AMOUNT'),
		itemId:'amount1',
		width:226,
		minValue:0,
		maxLength:10,
		hideTrigger:true,
		mouseWheelEnabled:false
	},{
		xtype:'textareafield',
		labelAlign:'top',
		name:'narration',
		width:450,
		fieldLabel:getFeeAndPaymentCommonTranslation('NARRATION'),
		itemId:'narration'
	},{
		xtype:'hidden',
		name:'feePlanId'
	},{		
		xtype:'hidden',
		name:'feePlanRuleStageId'
	},{		
		xtype:'hidden',
		name:'feeHeadId'
	},{		
		xtype:'hidden',
		name:'stageName'
	},{		
		xtype:'hidden',
		name:'feePlanType'
	},{
		xtype:'hidden',
		name:'raiseBillCategory'
	},{
		xtype: 'radiogroup',
		itemId:'isAutoSettlementPayment',
		name:'isAutoSettlementPayment',
		labelAlign:'top',
		fieldLabel: getFeeAndPaymentCommonTranslation('AUTO_SETTLEMENT'),
		columns: 2,
		vertical: true,
		items: [
		        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'onlineAutoAdjustment', inputValue: true},
		        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'onlineAutoAdjustment', inputValue: false,checked:true}
		        ]	
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : 'hbox',
		items: [{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			name:'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('RESET'),
			itemId: 'btnCancel',
			name:'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('SAVE_AND_ADJUSTMENT'),
			formBind: true,
			itemId: 'SubmitAndAdjustmentBtn',
			name:'SubmitAndAdjustmentBtn',
			ui: 'CustomBtnThird',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('SAVE_AND_GENERATEBILL'),
			formBind: true,
			hidden:true,
			itemId: 'SubmitAndGenerateBillBtn',
			name:'SubmitAndGenerateBillBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}] 	
	}]
});
