/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.receipts.FeeLedgerMasterList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feeledgermasterlist',
	store : 'feeandpayment.receipts.FeeLedgerMaster',
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	title:getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.receipts.FeeLedgerMaster',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
    	 xtype: 'button',
         itemId: 'btnAdd',
         tooltip: getFeeAndPaymentCommonTranslation('ADD'),
         glyph: ICONGLYPH.ADDGLYPH
     },{
    	 xtype: 'button',
         itemId: 'btnEdit',
         tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
         glyph: ICONGLYPH.EDITGLYPH
     },{
	     xtype: 'button',
         itemId: 'btnView',
         tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
         iconCls: 'view-icon'
     },{
         xtype: 'button',
         itemId: 'btnDelete',
         cls: 'CustomToolbarBtnReject',
         tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
         glyph: ICONGLYPH.DELETEGLYPH
    }],
	columns: [{
	        	header : getFeeAndPaymentCommonTranslation('LEDGER_NAME'),
	     		dataIndex : 'ledgerName',
	     		flex : 1	 
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('SEQUENCE_STATUS'),
	        	 dataIndex : 'academy',
		     	 flex : 1,
		     	renderer:function(value){
		     		if(value!=null){
					   return  value.value;
		     		}
				}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('LOCATION'),
		     	 dataIndex : 'location',
		     	 flex : 1,
		     	renderer:function(value){
		     		if(value!=null){
					   return  value.value;
		     		}
				}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('STATUS'),
		     	 dataIndex : 'status',
		     	 flex : 1,
		     	 renderer:function(value){
		     		if(value){
					return  getFeeAndPaymentCommonTranslation('ACTIVE');
			     	}else{
			     	return  getFeeAndPaymentCommonTranslation('IN_ACTIVE');
			     	}
				}
	         }]
});