/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.receipts.ManageReceiptForm', {   
//	extend:'Academia.view.common.IdGeneratorForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	formCode:'ManageReceiptForm',
	alias : 'widget.managereceiptform',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
	method : 'POST',
	title:getFeeAndPaymentCommonTranslation('RECEIPT_DETAILS'),
	frame:true,
	standardSubmit : false,
	width: '100%',
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'hidden',
			name:'offlinePaymentId',
			itemId:'offlinePaymentId'
		},{
			xtype:'hidden',
			name:'studentOfflinePaymentId',
			itemId:'studentOfflinePaymentId'
		},{
			xtype:'fieldcontainer',
			width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			cls: 'panelNoSpace'
		},
		items:[{
				xtype:'panel',
				items:[{
					xtype: 'radiogroup',
					itemId:'voucherMode',
					labelAlign:'top',
					width: 250,
					cls: 'paymentModeRadioCls',
					fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
					columns: 2,
					vertical: true,
					items: [
					        { boxLabel: getFeeAndPaymentCommonTranslation('BANK_LABEL'), name: 'voucherMode', inputValue:"BANK",checked:true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('CASH_LABEL'), name: 'voucherMode', inputValue:"CASH"}
					        ]
				     }]
			},{
				xtype:'panel',
				items:[{
					xtype: 'radiogroup',
					itemId:'receiptType',
					labelAlign:'top',
					width: 250,
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_MODE'),
					columns: 2,
					vertical: true,
					items: [
					        { boxLabel: getFeeAndPaymentCommonTranslation('REGULAR_LABEL'), name: 'receiptType', inputValue:"REGULAR",checked:true},
					       { boxLabel: getFeeAndPaymentCommonTranslation('PDC'), name: 'receiptType', inputValue:"PDC"}
					        ]
				     }]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width:'auto',
				defaults: {
					width: 226,
					labelAlign: 'top',
					xtype :'displayfield'
				},
				items:[{
					name: 'settlementStatus',
					itemId:'settlementStatus',
					hidden:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS')
					}]
			}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            name: 'fnpBrandCampusName',
            itemId: 'fnpBrandCampusItemId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
  			width: 460,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			queryParam:'qry',
			typeAhead:false,
			hideTrigger:false,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
		},
		{
			xtype: 'customcombobox',
			name: 'costCentre',
			itemId:'costCentre',
			fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
			store: 'feeandpayment.receipts.CostCentreReceipt',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			forceSelection:true,
		}]
	},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'textfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
				itemId:'receiptNo',
				//emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				//readOnly:true,
				name:'receiptNo'
			},{
				xtype: 'customcombobox',
				name: 'raiseBillType',
				itemId:'raiseBillType',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_TYPE'),
				store: 'feeandpayment.managebill.BillType',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'receiptForm',
				itemId:'receiptForm',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_FORM'),
				store: 'feeandpayment.managebill.BillForReceipts',
				valueField: 'id',
				//displayField: 'value',
				displayField: 'code',
				queryMode: 'local',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'checkboxfield',
	            name: 'inActiveStudent',
	            itemId:'inActiveStudentItemId',
	            labelAlign: 'right',
	            style:{
	            	marginTop:'25px !important'
	            },
	            boxLabel: getCommonTranslation('INACTIVE_STUDENT'),
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'receivingIAU',
				itemId:'receivingIAU',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_IAU'),
				store: 'feeandpayment.ALUnit',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true
			},{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
				itemId:'transactionDate',
				name:'transactionDate',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
//				value:new Date(),
				//allowBlank: false,
				//minValue : new Date()
				listeners: {
					render: function(obj) {
						var minDate  = new Date();
						obj = dateFormatRender(obj);						
						obj.setValue(minDate);
						obj.setMaxValue(minDate);
						/*Ext.Ajax.request({
				            type: 'rest',
				            url: SERVERURL.PATH_RECEIPT_SETTING_REST,
				            async:true,
				            method: 'GET',
				            headers: {
				                'Content-Type': 'application/json'
				            },
				            success: function(response) {
				            	if(!isNullOrEmpty(response.responseText)){
				            		var responseText  = Ext.decode(response.responseText);
				            		var minDate  = new Date();
				            		var days = responseText.numberOfDays;
				            		minDate = new Date(minDate.getTime() - (days * 24 * 60 * 60 * 1000));
				            		obj.setMinValue(minDate);
				            	} else{
				            		obj.setMinValue(new Date());
				            		}
				            }
				        });*/
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'depositedBankAcount',
				itemId:'depositedBankAcount',
				fieldLabel: getFeeAndPaymentCommonTranslation('OUR_BANK_ACCOUNT'),
				store: 'feeandpayment.receipts.DrawnOnBankStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				queryMode: 'local'
			},{
				xtype: 'customcombobox',
				name: 'depositedLedger',
				hidden:true,
				itemId:'depositedLedger',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEPOSITED_LEDGER'),
				store: 'feeandpayment.receipts.FeeLedgerName',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[//receipt date
				{
					xtype: 'customcombobox',
					name: 'student',
					itemId:'student',
					allowBlank:false,
					hidden:false,
					width:460,
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
					store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					queryCaching: false, 
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode}/{studentName}' +
							'</div>';
						}
					}
				},{
				xtype: 'customcombobox',
				name: 'thirdParty',
				itemId:'thirdParty',
				allowBlank:false,
				hidden:true,
				width:460,
				fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTIES'),
				store: 'feeandpayment.managebill.ThirdParties',
				valueField: 'id',
				displayField: 'firstName',
				queryParam:'codeOrPrintName',
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				//minChars:3,
				typeAhead:false,
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{firstName} {lastName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'sponsors',
				itemId:'sponsors',
				hidden:true,
				allowBlank:false,
				width:460,
				fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
				//store: 'feeandpayment.managebill.Sponsors',
				store:'sponsorship.SponsorsListForSuspenseStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'sponsorNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{sponsorshipCode}/{sponsorName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				hidden:true,
				allowBlank:false,
				width:460,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
				store: 'feeandpayment.managebill.Applicant',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'user',
				itemId:'userId',
				hidden:true,
				allowBlank:false,
				width:460,
				fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
				store: 'feeandpayment.managebill.User',
				valueField: 'id',
				displayField: 'nameToBePrinted',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{nameToBePrinted}' +
						'</div>';
					}
				}
			},
				{
				xtype: 'customcombobox',
				name: 'scholarship',
				itemId:'scholarship',
				hidden:true,
				width:460,
				fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
				store: 'feeandpayment.managebill.ScholarshipSmartSearch',
				valueField: 'id',
				displayField: 'scholarshipName',
				queryParam:'scholarshipNameOrCode',
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				//minChars:3,
				allowBlank:false,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{scholarshipCode}/{scholarshipName}' +
						'</div>';
					}
				}
//			}]
		},
		{
			xtype: 'customcombobox',
			name: 'receivingCurrency',
			itemId:'receivingCurrency',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
			store:'feeandpayment.AcademyCurrency',
			valueField: 'id',
			displayField: 'name',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true

		},{
			xtype: 'textfield',
			name: 'receivingCurrencyOfflinePayment',
			itemId:'receivingCurrencyOfflinePayment',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
			readOnly:true,
			hidden:true

		},{
			xtype: 'hidden',
			name: 'receivingCurrencyOfflinePaymentId',
			itemId:'receivingCurrencyOfflinePaymentId'
		}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
					xtype: 'customcombobox',
					name: 'scholarshipStudent',
					itemId:'scholarshipStudent',
					disabled:true,
					hidden:true,
					width:460,
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
					store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipStudent'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					allowBlank:false,
					queryCaching: false, 
					typeAhead:false,
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode}/{studentName}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'receivingCurrency2',
					itemId:'receivingCurrency2',
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
					store:'feeandpayment.AcademyCurrency',
					valueField: 'id',
					displayField: 'name',
					allowBlank:true,
					typeAhead:true,
					forceSelection:true,
					hidden: true
					}]
			},{
			xtype:'fieldcontainer',
			width: '100%',
			itemId:'addressDetails',
			layout : 'hbox',
			hidden:true,
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'displayfield',
				name: 'address',
				itemId:'address',
				fieldLabel: getFeeAndPaymentCommonTranslation('ADDRESS')
			},{
				xtype: 'displayfield',
				name: 'emailId',
				itemId:'emailId',
				fieldLabel: getFeeAndPaymentCommonTranslation('EMAIL')
			},{
				xtype:'displayfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('PHONE_NO'),
				itemId:'contactNo',
				name:'contactNo'
			}]
		},{
			xtype:'panel',
			itemId: 'receiptheaderPanel',
			style:{margin:'0px'},
			width: '100%',
			items:[{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox',
					align: 'bottom'
				},
				items: [{
					xtype: 'customcombobox',
					itemId: 'paymentMode',
					name: 'paymentMode',
					 width: 135,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
					labelAlign: 'top',
					store: 'feeandpayment.FeePaymentMode',
					valueField: 'id',
					displayField: 'value',
					//typeAhead:true,
				    forceSelection:true,
					allowBlank: false
				}, {
					xtype:'textfield',
					enableKeyEvents : true,
					itemId: 'instrumentsNo',
					labelAlign: 'top',
					width: 130,
					name: 'instrumentsNo',
					maxLength: 40,
					allowBlank: false,
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					listeners:{
						keypress : function(e, t){
							try {
								if (window.event) {
									var charCode = window.event.keyCode;
								}else if (e) {
									var charCode = e.which;
								}else { return true; }

								if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
									return t.preventDefault();
								}
							}
							catch (err) {
								alert(err.Description);
							} 
						},
						blur: function(me){
							var form = me.up('form').getForm();
							if(isNullOrEmpty(me.getValue())){
								me.up().up().up().down("#editBtn").setDisabled(true);
							}
							else if(form.isValid())
							{
								me.up().up().up().down("#editBtn").setDisabled(false);
							}
						}
					}
					/*xtype: 'numberfield',
					itemId: 'instrumentsNo',
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					labelAlign: 'top',
					width: 130,
					name: 'instrumentsNo',
					allowBlank: false,
					mouseWheelEnabled:false,
					hideTrigger:true,
					minValue:0,
					allowDecimals:false,
					maxLength: 40*/
	   			   // enforceMaxLength : true
				},{
					xtype:'datefield',
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
					itemId:'instrumentDate',
					name:'instrumentDate',
					labelAlign: 'top',
					width: 130,
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					allowBlank: false,
					maxValue:new Date(),
					//value:new Date()
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
//							obj.setValue(new Date());
						}
					}
				},{
					xtype: 'numberfield',
					itemId: 'amount',
					fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
					labelAlign: 'top',
					width: 130,
					name: 'amount',
					minValue: 0,
					allowDecimals:true,
					maxLength:13,
                    allowBlank: false,
		        	hideTrigger:true,
		        	mouseWheelEnabled:false,
		        	/*listeners: {
						render: function(obj) {
							   Ext.Ajax.request({
          				            type: 'rest',
          				            url: SERVERURL.PATH_RECEIPT_SETTING_REST,
          				            async:true,
          				            method: 'GET',
          				            headers: {
          				                'Content-Type': 'application/json'
          				            },
          				            success: function(response) {
          				            	if(!isNullOrEmpty(response.responseText)){
          				            		var responseText  = Ext.decode(response.responseText);
          				            		if(responseText.allowAmountValueInDecimal !=true){
          				            			obj.allowDecimals=false;
          				            		} else{
          				            			obj.allowDecimals=true;
          				            		}
          				            	}
          				            }
               				   });
						}
					}*/
				},{
					xtype: 'customcombobox',
					itemId: 'drawnOnBank',
					name: 'drawnOnBank',
					fieldLabel: getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
					labelAlign: 'top',
					width: '31%',
					store: 'feeandpayment.receipts.DrawnOnBank',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
 	        	    forceSelection:true,
					allowBlank: false      	  
				},{
					xtype: 'button',
					itemId: 'btnAddReceiptHeader0',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD')
				},{
					xtype:'hidden',
					name:'instrumentId'
				}] 
			}]
		},{
			xtype:'numberfield',
			mouseWheelEnabled:false,
			width:226,
			minValue:0,
			labelAlign:'top',
			hidden:true,
			hideTrigger:true,
			name:'amount1',
			maxLength:13,
			fieldLabel:getFeeAndPaymentCommonTranslation('AMOUNT'),
			itemId:'amount1',
			allowDecimals:true,
			/*listeners: {
				render: function(obj) {
					   Ext.Ajax.request({
				            type: 'rest',
				            url: SERVERURL.PATH_RECEIPT_SETTING_REST,
				            async:true,
				            method: 'GET',
				            headers: {
				                'Content-Type': 'application/json'
				            },
				            success: function(response) {
				            	if(!isNullOrEmpty(response.responseText)){
				            		var responseText  = Ext.decode(response.responseText);
				            		if(responseText.allowAmountValueInDecimal !=true){
				            			obj.allowDecimals=false;
				            		} else{
				            			obj.allowDecimals=true;
				            		}
				            	}
				            }
    				   });
				}
			}*/	
		},{
			xtype:'textareafield',
			labelAlign:'top',
			name:'narration',
			width:450,
			fieldLabel:getFeeAndPaymentCommonTranslation('NARRATION'),
			itemId:'narration'
		},{
			xtype:'textfield',
			labelAlign:'top',
			fieldLabel:getFeeAndPaymentCommonTranslation('EXTERNAL_RECEIPT_NO'),
			itemId:'externalReceiptNo',
			name:'externalReceiptNo',
			width:226,
			maxLength: 100
		},{
			xtype:'textareafield',
			labelAlign:'top',
			name:'cancellationReason',
			width:450,
			maxLength: 500,
			fieldLabel:getHostelTranslation('CANCELLATION_REASON'),
			itemId:'cancellationReason',
			hidden:true
		},{
			xtype:'hidden',
			name:'feePlanId'
		},{		
			xtype:'hidden',
			name:'feePlanRuleStageId'
		},{		
			xtype:'hidden',
			name:'feeHeadId'
		},{		
			xtype:'hidden',
			name:'stageName'
		},{		
			xtype:'hidden',
			name:'feePlanType'
		},{
			xtype:'hidden',
			name:'raiseBillCategory'
		},{
			xtype: 'radiogroup',
			itemId:'isAutoSettlementReceipt',
			labelAlign:'top',
			name:'onlineAutoAdjustment',
			fieldLabel: getFeeAndPaymentCommonTranslation('AUTO_SETTLEMENT'),
			columns: 2,
			vertical: true,
			items: [
			        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'onlineAutoAdjustment', inputValue: true},
			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'onlineAutoAdjustment', inputValue: false,checked:true}
			        ]	
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('RESET'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE_AND_ADJUSTMENT'),
				formBind: true,
				itemId: 'SubmitAndAdjustmentBtn',
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE_AND_PRINT'),
				formBind: true,
				itemId: 'SubmitAndPrintBtn',
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'editBtn',
				ui: 'CustomBtnSubmit',
				visible:false,
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]}]
});