/**
 * @author Ranga
 */
Ext.define('Academia.view.feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.applicantfeeheadwisecollectionreportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{

			xtype : 'customcombobox',
			name : 'intakeyear',
			itemId: 'intakeyear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			width:226
		
		},{
			xtype:'customcombobox',
			name:'feePlanTypeId',
			itemId:'feePlanTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store:'feeandpayment.FeePlanTypeStore',
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype:'customcombobox',
			name:'feeHeadId',
			itemId:'feeHeadId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD'),
			store:'feeandpayment.reports.FeeHeadWiseFeeReportStore',
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top',
				/*//xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				//allowDecimals:false,
				//allowExponential:false
*/			},
		items:[{
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
            store:'program.ProgramCategoryStoreSmartSearch',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            minChars:3,
            queryParam:'query',
	    	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		     }
        },{
		    	   xtype:'customcombobox',
		    	   name:'programId',
		    	   itemId:'programId',
		    	   //width:460,
		    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    	   store:Ext.create('Academia.store.feeandpayment.reports.ProgramStudentByIntakeYearStore'),
		    	   displayField:'valueCode',
		    	   valueField:'id',
		    	   typeAhead:true,
		    	   forceSelection:true,
		    	   hideTrigger:false,
		    	   triggerAction: 'all',
		    	   minChars:3,
		    	   queryParam:'programName',
		    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	   listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
			   },{
					xtype: 'customcombobox',
					name: 'batchId',
					disabled:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
					itemId:'batchId',
					store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'seatTypeId',
			disabled:true,
			itemId:'seatTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			store: Ext.create('Academia.store.feeandpayment.reports.ProgramBatchSeatIdByBatchStudentIdStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},/*{
			xtype: 'customcombobox',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
			disabled : true
		},*/{
			xtype:'customcombobox',
			name:'applicantId',
			itemId:'applicantId',
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
			store: 'feeandpayment.managebill.Applicant',
			valueField: 'id',
			displayField: 'printName',
			
			typeAhead:false,
			forceSelection:false,
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'checkboxfield',
            width: 'auto',
            style:{
            	marginTop:'25px'
            },
            labelAlign: 'right',
            itemId:'whetherApplicantId',
            boxLabel: getCommonTranslation('ONLY_APPLICANT'),
            name: 'whetherApplicant',
            inputValue : true
        }]	
	},
	
	{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name: 'billDateForm',
			itemId:'billDateForm',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype: 'daterange',
			endDateField: 'billDateTill',
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_FORM')
		},{
			xtype: 'datefield',
			name: 'billDateTill',
			itemId:'billDateTill',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype: 'daterange',
			startDateField: 'billDateForm',
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_TILL')
		}]
	},]	
	}
	
	
	],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	
	
	]
});
