/**
 * @author Anand Verma
 */
var applicantFeeReportStore = 'feeandpayment.reports.ApplicantFeeReport';
Ext.define('Academia.view.feeandpayment.reports.ApplicantFeeReportGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.applicantfeereportgrid',
	store: applicantFeeReportStore,
	title: getCommonTranslation('APPLICANT_CONSOLIDATED_FEE_REPORT'),
	cls:'centerAlignTitle',
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.reports.ApplicantFeeReport',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[
	         {
	        	 header : getCommonTranslation('APPLICANT_ID'),
	        	 dataIndex : 'applicationCode',
	        	 flex:1,
	        	 sortable:true,
	        	 renderer:function(value){
	        		 return '<a href=#>'+value+'</a>'
	        	 },
	        	 summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
		     			if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
		     				return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
		     			}
		     			else {
		     				return getFeeAndPaymentCommonTranslation('TOTAL');
		     			}
		     		}
	         },{
	        	 header : getCommonTranslation('APPLICANT_NAME'),
	        	 dataIndex : 'printName',
	        	 flex:1
	         },{
	        	 header : getCommonTranslation('FATHER_NAME'),
	        	 dataIndex : 'fatherName',
	        	 flex:1
	         },{
	        	 header : getCommonTranslation('PROGRAM'),
	        	 dataIndex : 'programName',
	        	 flex:1
	         },{
	        	 header : getCommonTranslation('BATCH'),
	        	 dataIndex : 'batchName',
	        	 flex:1
	         },{
	        	 header : getCommonTranslation('SEAT_TYPE'),
	        	 dataIndex : 'seatName',
	        	 flex:1
	         },{
		     	header:getCommonTranslation('TOTAL_AMOUNT'),
		    	dataIndex:'feeAmount',
		    	flex : 1,
		    	hidden: true,
		    	//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		    	summaryType: 'sum',
		    	renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				if(store.data.items[0].data.conversionType == 'EX'){
	    					return currencyRenderer(value,record.get("currencyId"));
		        		 }
		        		else {
		        			return currencyRenderer(value,store.data.items[0].data.currencyId);
		        		}
	    			}
	    		}
		     },{
		    	header:getCommonTranslation('DISCOUNT_AMOUNT'),
		    	dataIndex:'discountAmount',
		    	flex : 1,
		    	hidden: true,
		    	//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		    	summaryType: 'sum',
		    	renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				if(store.data.items[0].data.conversionType == 'EX'){
	    					return currencyRenderer(value,record.get("currencyId"));
		        		 }
		        		else {
		        			return currencyRenderer(value,store.data.items[0].data.currencyId);
		        		}
	    			}
	    		}
		    	},{
	        	 header : getCommonTranslation('TOTAL_BILL'),
	        	 dataIndex : 'totalBillAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 //align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
		    			if(!isNullOrEmpty(value)){
		    				if(store.data.items[0].data.conversionType == 'EX'){
		    					return currencyRenderer(value,record.get("currencyId"));
			        		 }
			        		else {
			        			return currencyRenderer(value,store.data.items[0].data.currencyId);
			        		}
		    			}
		    		}
	         },{
	        	 header : getCommonTranslation('TOTAL_RECEIPT_AMOUNT_SETTLED'),
	        	 dataIndex : 'totalNetCollectionAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 //align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
		    			if(!isNullOrEmpty(value)){
		    				if(store.data.items[0].data.conversionType == 'EX'){
		    					return currencyRenderer(value,record.get("currencyId"));
			        		 }
			        		else {
			        			return currencyRenderer(value,store.data.items[0].data.currencyId);
			        		}
		    			}
		    		}
	         },{
	        	 header : getCommonTranslation('TOTAL_OUTSTANDING'),
	        	 dataIndex : 'totalOutstandingAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 //align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
		    			if(!isNullOrEmpty(value)){
		    				if(store.data.items[0].data.conversionType == 'EX'){
		    					return currencyRenderer(value,record.get("currencyId"));
			        		 }
			        		else {
			        			return currencyRenderer(value,store.data.items[0].data.currencyId);
			        		}
		    			}
		    		}
	         },{
	        	 header : getCommonTranslation('TOTAL_PAYMENT'),
	        	 dataIndex : 'totalPaymentAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 //align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
		    			if(!isNullOrEmpty(value)){
		    				if(store.data.items[0].data.conversionType == 'EX'){
		    					return currencyRenderer(value,record.get("currencyId"));
			        		 }
			        		else {
			        			return currencyRenderer(value,store.data.items[0].data.currencyId);
			        		}
		    			}
		    		}
	         },{
	        	 header : getCommonTranslation('NET_OUTSTANDING_AMOUNT'),
	        	 dataIndex : 'netOutStandingAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 //align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
		    			if(!isNullOrEmpty(value)){
		    				if(store.data.items[0].data.conversionType == 'EX'){
		    					return currencyRenderer(value,record.get("currencyId"));
			        		 }
			        		else {
			        			return currencyRenderer(value,store.data.items[0].data.currencyId);
			        		}
		    			}
		    		}
	         },{
	        	 header : getCommonTranslation('ADDRESS'),
	        	 dataIndex : 'address',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getCommonTranslation('EMAIL_ID'),
	        	 dataIndex : 'emailId',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getCommonTranslation('MOBILE_NUMBER'),
	        	 dataIndex : 'mobileNo',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getCommonTranslation('FIRST_NAME'),
	        	 dataIndex : 'personFirstName',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getCommonTranslation('MIDDLE_NAME'),
	        	 dataIndex : 'personMiddleName',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getCommonTranslation('LAST_NAME'),
	        	 dataIndex : 'personLastName',
	        	 flex:1,
	        	 hidden:true
	         }]

}
);
