/**
 *@author Nitin Gaikwad
 */
var programWiseConsolidatedReport= 'feeandpayment.reports.ProgramWiseFeeReport';
Ext.define('Academia.view.feeandpayment.reports.ProgramWiseFeeReportGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.programwisefeereportgrid',
	store:programWiseConsolidatedReport,
	title: getCommonTranslation('PROGRAM_WISE_CONSOLIDATED_FEE_REPORT'),
	cls:'centerAlignTitle',
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : programWiseConsolidatedReport,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[{
		header : getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'programGroup',
		flex:1,
		summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
			else {
				var splitValue = summaryData.value.split(" ");
				return getFeeAndPaymentCommonTranslation('TOTAL')+' (In '+store.data.items[0].data.currencyName+')';
			}


		}
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_BILL'),
		dataIndex : 'totalBillAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/* summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
		  return  value;
	  },*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			/*if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}*/

			if(!isNullOrEmpty(value)){
//				return currencyRenderer(value,record.get("currencyId"));
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value,record.get("currencyId"));
				}
				else {
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}

		},
	},{
		header : getCommonTranslation('TOTAL_RECEIPT'),
		dataIndex : 'totalNetCollectionAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/* summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
		  return  value;
	  },*/
		renderer:function(value, metaData, record, row, col, store, gridView){

			if(!isNullOrEmpty(value)){
//				return currencyRenderer(value,record.get("currencyId"));
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value,record.get("currencyId"));
				}
				else {
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}
		},
	},{
		header : getCommonTranslation('TOTAL_PAYMENT'),
		dataIndex : 'totalPaymentAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
		  return  value;
	  },*/
		renderer:function(value, metaData, record, row, col, store, gridView){

			if(!isNullOrEmpty(value)){
//				return currencyRenderer(value,record.get("currencyId"));
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value,record.get("currencyId"));
				}
				else {
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}
		},
	},{
		header : getCommonTranslation('TOTAL_OUTSTANDING'),
		dataIndex : 'totalOutstandingAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*  summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
		  return  value;
	  },*/
		renderer:function(value, metaData, record, row, col, store, gridView){

			if(!isNullOrEmpty(value)){
//				return currencyRenderer(value,record.get("currencyId"));
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value,record.get("currencyId"));
				}
				else {
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}
		},
	},{
		header : getCommonTranslation('NET_OUTSTANDING_AMOUNT'),
		dataIndex : 'netOutStandingAmount',
		flex:1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/* summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
		  return  value;
	  },*/
		renderer:function(value, metaData, record, row, col, store, gridView){

			if(!isNullOrEmpty(value)){
//				return currencyRenderer(value,record.get("currencyId"));
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value,record.get("currencyId"));
				}
				else {
					return currencyRenderer(value,store.data.items[0].data.currencyId);
				}
			}
		},
	}]

});
