/**
 * @author Harsh Raghuwanshi
 */
Ext.define('Academia.view.feeandpayment.reports.VoucherSummaryReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.vouchersummaryreportgrid',
	title: getCommonTranslation('VOUCHER_SUMMARY'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'vouchersummaryreporttabstructure':1
		}
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);


		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.feeandpayment.reports.VoucherSummaryReportGridStore');
	},
	columns: [{
		header : getCommonTranslation('IAU'),
		dataIndex : 'iau',
		flex : 1,
		//summaryRenderer: function(value, summaryData, dataIndex) {
		summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			//return getFeeAndPaymentCommonTranslation('TOTAL');
			if(store.data.items[0].data.academyLocationBaseCurrency == null){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
			else {
				var splitValue = summaryData.value.split(" ");
				return getFeeAndPaymentCommonTranslation('TOTAL')+' (In '+store.data.items[0].data.baseCurrencyName+')';
			}
		}
	},{
		header : getCommonTranslation('VOUCHER_ID'),
		dataIndex : 'voucherID',
		flex : 1
	},{
		header : getCommonTranslation('VOUCHER_DATE'),
		dataIndex : 'voucherDate',
		flex : 1,
		renderer:function(value){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
	},{
		header : getCommonTranslation('VOUCHER_MODE'),
		dataIndex : 'voucherMode',
		flex : 1,
		hidden:true,
		renderer : function(value){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header :getCommonTranslation('FP_TRANSACTION_TYPE'),
		dataIndex : 'transactionType',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header : getCommonTranslation('FP_FEE_TYPE'),
		dataIndex : 'feeType',	
		flex : 1,
		hidden:true,
		renderer : function(value){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header : getCommonTranslation('CONTROL_ACCOUNT'),
		dataIndex : 'controlAccount',
		flex : 1

	},{
		header : getCommonTranslation('NARRATION'),
		dataIndex : 'narration',
		hidden:true,
		flex : 1	
	},{
		header : getCommonTranslation('DEBIT'),
		dataIndex : 'debitAmount',
		flex : 1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(store.data.items[0].data.academyLocationBaseCurrency == null){

					return currencyRenderer(value,record.get("currencyId"));
				}
				else
				{
					return currencyRenderer(value,record.get("createdCurrencyId"));
					//return currencyRenderer(value,store.data.items[0].data.academyLocationBaseCurrency);
				}
			}



		},
		summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.academyLocationBaseCurrency != null){
				return currencyRenderer(value,store.data.items[0].data.academyLocationBaseCurrency);
			}
			else
			{
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}

	},{
		header : getCommonTranslation('CREDIT'),
		dataIndex : 'creditAmount',
		flex : 1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
//			if(!isNullOrEmpty(value)){
//			return currencyRenderer(value,record.get("currencyId"));
//			}

			if(!isNullOrEmpty(value)){
				if(store.data.items[0].data.academyLocationBaseCurrency == null){

					return currencyRenderer(value,record.get("currencyId"));
				}
				else
				{
					return currencyRenderer(value,record.get("createdCurrencyId"));
					//return currencyRenderer(value,store.data.items[0].data.academyLocationBaseCurrency);
				}
			}

		},
		summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.academyLocationBaseCurrency != null){
				return currencyRenderer(value,store.data.items[0].data.academyLocationBaseCurrency);
			}
			else
			{
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}

	}]
});

