/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.voucherMode.VoucherModeInnerList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.vouchermodeinnerlist',
	store : 'feeandpayment.voucherMode.VoucherModeInnerList',
	border: true,
	title: getCommonTranslation('VOUCHER_MODE_DETAIL'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.voucherMode.VoucherModeInnerList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getCommonTranslation('CONTROL_ACCOUNT'),
		dataIndex : 'controlAccount',
		flex : 1	
	},{
		header : getCommonTranslation('SUB_LEDGER_ACCOUNT'),
		dataIndex : 'ledgerName',
		flex : 1
	},{
		header : getCommonTranslation('NARRATION'),
		dataIndex : 'narration',
		flex : 1
	},{
		header : getCommonTranslation('DEBIT'),
		dataIndex : 'debitAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                        
		} 
	},{
		header : getCommonTranslation('CREDIT'),
		dataIndex : 'creditAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                        
		} 
	}]
});