/*
 * Kamlesh
 */
Ext.define('Academia.view.gradeMaster.grade.GradeMasterAddForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.grademasteraddform',
//    title: getExaminationTranslation('ADD_GRADE'),
    autoScroll: true,
//    frame: false,
    border:false,
    method: 'POST',
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    defaults: {
        labelAlign: 'top'
    },
    plugins:"formlabelrequired",
    items: [{
	        xtype: 'hidden',
	        name: 'id'
	    },{
	        xtype: 'hidden',
	        name: 'extraId'
	    },{
    	xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
        items: [{
            xtype: 'customcombobox',
            name: 'gradeType',
            itemId:'gradeTypeItemId',
            fieldLabel: getExaminationTranslation('GRADE_TYPE'),
            store:'gradeMaster.GradeTypeNameValueStore',
            displayField:'value',
            valueField:'value',
            allowBlank: false,
            forceSelection:true,
 			typeAhead:true,
     		minChars:3
        },{
            xtype: 'textfield',
            name: 'gradeName',
            itemId:'gradeName',
            //maskRe: /[a-zA-Z_@#$%&*(){}+-\s]/,
            //vtype: 'someSpecialCharactersWithAplhaNumericAsInput',
            fieldLabel:getExaminationTranslation('GRADE_NAME'),
            maxLength:45,
            allowBlank: false
        }]
    },{
    	xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
        items: [ {
                xtype: 'numberfield',
                name: 'gradeRangeFrom',
                itemId:'gradeRangeFrom',
                fieldLabel:getExaminationTranslation('GRADE_POINT_RANGE_FROM'),
                minValue : 0,
	        	allowDecimals:true,
	        	hideTrigger:true,
	        	mouseWheelEnabled:false,
                allowBlank: false,
    	   	    validator : function(val) {
   	       		 var maxValuefield = this.nextSibling();
   	       		 var maxValue = maxValuefield.getValue();
   	       		 if (maxValue != null) {
   	       			 if (val < maxValue) {
   	       				 maxValuefield.clearInvalid();
   	       				 return true;
   	       			 } else {
   	       				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
   	       			 }
   	       		 } else {
   	       			 return true;
   	       		 }
   	       	   }
        }, {
            xtype: 'numberfield',
            name: 'gradeRangeTo',
            itemId:'gradeRangeTo',
            fieldLabel:getExaminationTranslation('GRADE_POINT_RANGE_TO'),
            minValue : 0,
        	allowDecimals:true,
        	hideTrigger:true,
        	mouseWheelEnabled:false,
            allowBlank: false,
   	   	    validator : function(val) {
    	   		 var minValueField =this.previousSibling();
    	   		 var minValue = minValueField.getValue();
    	   		 if (minValue != null) {
    	   			 if (val > minValue) {
    	   				 minValueField
    	   				 .clearInvalid();
    	   				 return true;
    	   			 } else {
    	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
    	   			 }
    	   		 } else {
    	   			 return true;
    	   		 }
    	   	  }
        }]
   }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [/**
                 *This field is hidden as discussed with pushpendra sir.   
                 */
           {
        	xtype      : 'radiogroup',
            fieldLabel : getExaminationTranslation('IS_GRADE_PART_OF_GROUP'),
            itemId: 'hasGroupRadioItemId',
            name:'hasGroupRadio',
            hidden:true,
            defaults: {
                flex: 1
            },
            layout: 'hbox',
            items:[{ 
            	boxLabel: getCommonTranslation('YES'), 
            	name: 'hasGroup', 
            	inputValue: true,
            	checked:true
            },{ 
            	boxLabel: getCommonTranslation('NO'), 
            	name: 'hasGroup', 
            	inputValue: false
            }]
        },{
            	xtype: 'customcombobox',
                name: 'gradeStatus',
                fieldLabel: getCommonTranslation('STATUS'),
                store:'gradeMaster.GradeStatusStore',
                displayField:'value',
                valueField:'id',
                allowBlank: false,
 				typeAhead:true,
                forceSelection:true,
     			minChars:3,
				queryMode :'local'
        },{
        	/**
        	 * This field is moved to this row because IS_GRADE_PART_OF_GROUP, minPercent and maxPercent are hidden.
        	 */
        	xtype: 'numberfield',
            name: 'gradePoint',
            fieldLabel: getExaminationTranslation('GRADE_POINT'),
            minValue : 0,
            allowDecimals:true,
        	hideTrigger:true,
        	mouseWheelEnabled:false,
            allowBlank: false
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [{
            xtype: 'numberfield',
            name: 'minPercent',
            fieldLabel: getExaminationTranslation('MIN_PERMISSIBLE_PERCENTAGE'),
            minValue : 0,
        	allowDecimals:true,
        	hideTrigger:true,
        	mouseWheelEnabled:false,
            allowBlank: true,
            hidden:true,
	   	    validator : function(val) {
	       		 var maxValuefield = this.nextSibling();
	       		 var maxValue = maxValuefield.getValue();
	       		 if (maxValue != null) {
	       			 if (val < maxValue) {
	       				 maxValuefield.clearInvalid();
	       				 return true;
	       			 } else {
	       				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
	       			 }
	       		 } else {
	       			 return true;
	       		 }
	       	   }
        },{
            xtype: 'numberfield',
            name: 'maxPercent',
            fieldLabel: getExaminationTranslation('MAX_PERMISSIBLE_PERCENTAGE'),
            minValue : 0,
        	allowDecimals:true,
        	hideTrigger:true,
        	mouseWheelEnabled:false,
            allowBlank: true,
            hidden:true,
   	   	    validator : function(val) {
 	   		 var minValueField =this.previousSibling();
 	   		 var minValue = minValueField.getValue();
 	   		 if (minValue != null) {
 	   			 if (val > minValue) {
 	   				 minValueField
 	   				 .clearInvalid();
 	   				 return true;
 	   			 } else {
 	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
 	   			 }
 	   		 } else {
 	   			 return true;
 	   		 }
 	   	  }
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [{
        	xtype: 'textfield',
            name: 'gradeDescription',
            itemId: 'gradeDescription',
            maxLength:255,
            fieldLabel: getExaminationTranslation('GRADE_DESCRIPTION'),
            listener:{
				blur:function(){}
			}
        },
        {
        	xtype: 'textfield',
            name: 'gradeDescriptionOther',
            itemId: 'gradeDescriptionOther',
            maxLength:255,
            fieldLabel: getExaminationTranslation('GRADE_DESCRIPTION_IN_OTHER_LANGAUGE'),
            listener:{
				blur:function(){}
			}
        	
        },
     ]
    },{

        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [
        {
            xtype: 'customcombobox',
            name: 'resultStatus',
            itemId:'resultStatusItemId',
            fieldLabel: getExaminationTranslation('EXAM_GRADE_RESULT_STATUS'),
            store:'gradeMaster.ExamResultStatusStore',
            displayField:'value',
            valueField:'value',
            allowBlank: false,
            forceSelection:true,
            hidden:true,
		
        },{ 
				    xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: '',
		            itemId:'editableTransferMarkstoGradeId',//Editable for Transfer Marks to Grade
		            boxLabel:getCommonTranslation('EDITABLE_GRADE'),
		            name: 'editableTransferMarkstoGradeId',
		            inputValue : true, 
		            uncheckedValue: false,         
                    hidden:false,       
					disabled:true,
					style:{
			        		marginLeft:'8px',
			        		marginTop:'28px'
			        	  },      
						}]
    
    },
    {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [{
        	xtype: 'radiogroup',
            name: 'contributionInTheTotalCredits',
            itemId: 'contributionInTheTotalCredits',
            maxLength:255,
            fieldLabel: getExaminationTranslation('CONTRIBUTE_IN_THE_TOTAL_CREDITS'),
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'isContributeInTheTotalCredits',
				inputValue : true,
				checked : true

			}, {
				boxLabel : getExaminationTranslation('NO'),
				name : 'isContributeInTheTotalCredits',
				inputValue : false
			} ],
        },{
            xtype: 'radiogroup',
            name: 'contributeInTheSgpaCgpa',
            itemId:'contributeInTheSgpaCgpa',
            fieldLabel: getExaminationTranslation('CONTRIBUTE_IN_THE_SGPA_CGPA'),
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'isContributeInTheSgpaCgpa',
				inputValue : true,
				checked : true

			}, {
				boxLabel : getExaminationTranslation('NO'),
				name : 'isContributeInTheSgpaCgpa',
				inputValue : false,
			} ],
        },{
        	xtype: 'textfield',
            name: 'isSpecialGrade',
            itemId: 'isSpecialGrade',
            maxLength:255,
            fieldLabel: getExaminationTranslation('isSpecialGrade'),
            hidden:true
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'radiogroup',
    		name: 'publishMarksOnSP',
    		itemId: 'publishMarksOnSP',
    		width: 230,
    		fieldLabel: getExaminationTranslation('PUBLISH_MARKS_ON_SP'),
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items: [{
    			boxLabel: getExaminationTranslation('YES'),
    			name: 'isPublishMarksOnSP',
    			inputValue: true,
    			checked: true
    		}, {
    			boxLabel: getExaminationTranslation('NO'),
    			name: 'isPublishMarksOnSP',
    			inputValue: false
    		}]
    	},{
    		xtype: 'radiogroup',
    		name: 'publishGradesOnSP',
    		itemId: 'publishGradesOnSP',
    		width: 240,
    		fieldLabel: getExaminationTranslation('PUBLISH_GRADES_ON_SP'),
    		margin: '0 0 0 -4',
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items: [{
    			boxLabel: getExaminationTranslation('YES'),
    			name: 'isPublishGradesOnSP',
    			inputValue: true,
    			checked : true
    		}, {
    			boxLabel: getExaminationTranslation('NO'),
    			name: 'isPublishGradesOnSP',
    			inputValue: false
    		}]
    	},{
    		xtype: 'textfield',
    		name: 'isSpecialGrade',
    		itemId: 'isSpecialGrade',
    		maxLength:255,
    		fieldLabel: getExaminationTranslation('isSpecialGrade'),
    		hidden:true
    	}]
    }, {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'radiogroup',
    		disabled: true,
    		hidden: true,
    		name: 'whetherDeleteMarks',
    		flex: 1,
    		fieldLabel: getExaminationTranslation('MARKS_DELETED_DURING_DELETE_SPECIAL_GRADE'),
    		layout: 'hbox',
    		defaults: {
    			width: 110
    		},
    		items: [{
    			boxLabel: getExaminationTranslation('YES'),
    			name: 'isDeleteMarks',
    			inputValue: true,
    			checked: true
    		}, {
    			boxLabel: getExaminationTranslation('NO'),
    			name: 'isDeleteMarks',
    			inputValue: false
    		}]
    	}]
    }, {
        layout: {
            type: 'hbox'
        },
        style:{
     		 marginLeft:'0px'
     	 },
        items: [{
            xtype: 'button',
            text: getExaminationTranslation('SAVE'),
            itemId: 'gradeMasterAddButtonId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getExaminationTranslation('RESET'),
            itemId: 'gradeMasterResetButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            handler: function() {
                this.up('form').getForm().reset();
                
            }
        }]
    }]
});