/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.hostel.manageroomtype.ChargeableNonChargeableDaysScheduleEditGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.chargeablenonchargeabledaysscheduleeditgrid',
	store: 'hostel.manageroomtype.ChargeableNonChargeableDaysScheduleGridStore',
	title: getHostelTranslation("CHARGEABLE_NON_CHARGEABLE_DAY_SCHEDULE"),
	border: true,
	selModel: {
        selType: 'checkboxmodel',
        showHeaderCheckbox: true,
        listeners: {
            beforeselect: function(grid, record) {
                if (viewMode) {
                    return false;
                }
            }
        }
    },
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.manageroomtype.ChargeableNonChargeableDaysScheduleGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	} /*{
		xtype: 'button',
		itemId: 'copyScheduleFrom',
		cls: 'CustomBodyBtnSettings',
		text: getHostelTranslation('COPY_SCHEDULE_FROM'),
		tooltip: getHostelTranslation("COPY_SCHEDULE_FROM"),
	}*/],
	columns: [{
		header:  getHostelTranslation("DATE"),
		dataIndex:'date',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getHostelTranslation("DAY"),
		dataIndex:'day',
		flex:.1,
		sortable:true
	},{
		header:  getHostelTranslation("PER_DAY_TARIFF"),
		dataIndex: 'feeHeadAmount',
		flex:.1,
		sortable:true,
	}]
});
