Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingSetupCustomColumnGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.jobpostingsetupcustomcolumngrid',	
	store:'hrRecruitmentProcess.jobPosting.JobPostingSetupCustomColumnStore', 
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSaveCustom'
	}],	
	columns:[{
		header:getCommonTranslation('COLUMN_NAME'),
		dataIndex:'displayName',
		flex:1,
		renderer:function(value) {
			return value;
		}	
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('MODULE_VISIBILITY'),
		flex:1,
		dataIndex : 'isVisible',
		renderer: function(value, metadata,record) {
			var data=record.data;
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
		}			
	},{
		xtype:'checkcolumn',
		flex:1,
		header:getCommonTranslation('WHETHER_COLUMN_MANDATORY'),
		dataIndex : 'isMandatory'	,
		renderer: function(value, metadata,record) {
			var data=record.data;
				 var disabled=!data.isVisible;
				 if(disabled){
					 metadata.style+= ' opacity:0.3';
					 value=data.isMandatory;
				 }
				
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
		},
		 processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
			 if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
				var record = view.panel.store.getAt(recordIndex);
				var data=record.data;
				var disabled=!data.isVisible;
				 //do not change data and fire checkchange event if it's disabled
				 view.focusRow(recordIndex);
				 if (!disabled) {
	                        dataIndex = this.dataIndex;
	                        checked = !record.get(dataIndex);
	                        record.set(dataIndex, checked);
	                        this.fireEvent('checkchange', this, recordIndex, checked);
	              }
				 return false;
                }
            }	
	},{
		/*
		 * If custom field false means it is custom category
		 * If custom filed true means it is not custom category
		 **/
		header:getCommonTranslation('WHETHER_CUSTOM_CATEGORY'),
		flex:1,
		dataIndex : 'whetherCustomField',
		renderer:function(value) {
			if (value == true) {
				return 'No';	
			}else{
				return 'Yes';
			}
			
		}
	}],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    }
}
);