/**
 * @ author Kamini Birla
*/
Ext.define('Academia.view.hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentConsolidatedReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.icattendanceandpaymentconsolidatedreportgrid',
	store: 'hrm.report.ICAttendanceAndPaymentConsolidatedReportGridStore',
	title: getCommonTranslation('IC_ATTENDANCE_AND_PAYMENT_CONSOLIDATED_REPORT'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hrm.report.ICAttendanceAndPaymentConsolidatedReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCommonTranslation('EMPLOYEE_NUMBER'),
		dataIndex : 'employeeId',
		flex : 1
	},
	{
		header : getCommonTranslation('EMPLOYEE_FIRST_NAME'),
		dataIndex : 'empFirstName',
		flex : 1
	},
	{
		header : getCommonTranslation('EMPLOYEE_SURNAME'),
		dataIndex : 'empSurName',
		flex : 1
	},{
		header : getCommonTranslation('NAME_SURNAME'),
		dataIndex : 'empFullName',
		flex : 1
	},{
		header : getCommonTranslation('EMAIL_ADDRESS'),
		dataIndex : 'emailAddress',
		flex : 1
	},{
		header : getCommonTranslation('INPUT_TYPE'),
		dataIndex : 'inputType',
		flex : 1
	},{
		header : getCommonTranslation('PAY_RATE'),
		dataIndex : 'payRate',
		flex : 1
	},{
		header : getCommonTranslation('MONTH'),
		dataIndex : 'month',
		flex:1
	},{
		header : getCommonTranslation('INPUT_VALUE'),
		dataIndex : 'inputValue',
		flex : 1
	},{
		header : getCommonTranslation('MODULE_SERVICE'),
		dataIndex : 'moduleService',
		flex : 1
	},{
		header : getCommonTranslation('TOTAL_PAYMENT'),
		dataIndex : 'totalPayment',
		flex : 1
	},{
		header : getCommonTranslation('COST_CENTER'),
		dataIndex : 'costCenter',
		flex : 1
	},{
		header : getCommonTranslation('COMPONENT_DESCRIPTION'),
		dataIndex : 'componentDescription',
		flex : 1
	}]
});