/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.biometric.BMIFormResourceGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bmiformresourcegrid',
    store: 'hrm.biometric.BMIFormResourceGridStore',
    border: true,
  viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    title : getCommonTranslation('BMI_LIST_OF_RESOURCES'),
    selType:'checkboxmodel',
    selModel: {
		mode:'MULTI'
		//showHeaderCheckbox: true,
		//allowDeselect: false,
		//checkOnly : true
	},
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex: 1
    },{
        header: getCommonTranslation('RESOURCE_GROUP'),
        dataIndex: 'resourceGroup',
        flex: 1,
        renderer:function(val){   		  
			 return getCommonTranslation(val);
		 }
    },{
        header: getCommonTranslation('RESOURCE_TYPE'),
        dataIndex: 'resourceType',
        flex: 1
    },{
        header: getCommonTranslation('RESOURCE_NAME'),
        dataIndex: 'resourceName',
        flex: 1
    }]
});