/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.hrm.biometric.BMIGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.bmigrid',
	store: 'hrm.biometric.BMIGridStore',
	title: getCommonTranslation('BMI_GRID_TITLE'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hrm.biometric.BMIGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[/*{
			text: getFileManagementTranslation('ASSIGN_TO'),
			itemId: 'btnAssignTo',
		},{
			text:getFileManagementTranslation('UPDATE_STATUS'),
			itemId:'btnUpdateStatus'
		},{
			text:getFileManagementTranslation('UPLOAD_DOCUMENT'),
			itemId:'btnUploadDocument'
		}*/],
		//listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header:  getCommonTranslation('BMI_MACHINE_ID'),
		dataIndex: 'machineCode',
		flex:.8,
		sortable:true
	},{
		header:  getCommonTranslation('BMI_MACHINE_NAME'),
		dataIndex: 'machineName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BMI_MACHINE_IP'),
		dataIndex: 'machineIP',
		flex:1,
		sortable:true
	},{
		header: getCommonTranslation('ACADEMY_LOCATIONS'),
		dataIndex: 'academyLocationCount',
		flex:.8,
		sortable: true,
		renderer: function(value, metadata, record) {
			if (!isNullOrEmpty(value) && value>0) {
				return '<a href="#">'+ value +'</a>';
			}
			return '';
		}
	},{
		header: getCommonTranslation('RESOURCE_NAME'),
		dataIndex: 'resourceCount',
		flex:.8,
		sortable: true,
		renderer: function(value, metadata, record) {
			if (!isNullOrEmpty(value) && value>0) {
				return '<a href="#">'+ value +'</a>';
			}
			return '';
		}
	},{
		header:  getCommonTranslation('ACTION'),
		dataIndex: 'action',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				if(value == 'IN_OUT'){
					return getCommonTranslation('IN_OUT');
				} else if(value == 'IN'){
					return getCommonTranslation('IN');
				} else if(value == 'OUT'){
					return getCommonTranslation('OUT');
				}
			}
			return value;
		}
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'isActive',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(value == false || value == 'false'){
				return 'Inactive';
			} else {
				return 'Active';
			}

		} 
	}]
});
