/**
 * @author Deepak S
 */
Ext.define('Academia.view.hrm.report.BMStudentPunchLogReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.bmstudentpunchlogreportgrid',
	store: 'hrm.report.BMStudentPunchLogReportGridStore', // TODO change store
	title: getPersonModuleTranslation('BM_STUDENT_PUNCH_LOG_REPORT'),
	border: true,
	refreshStoreData: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'hrm.report.BMStudentPunchLogReportGridStore', // TODO change store
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns: [{
		header: getPersonModuleTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex: 1,
		sortable: false
	}, {
		header: getPersonModuleTranslation('NAME'),
		dataIndex: 'studentName',
		flex: 1,
		sortable: false
	}, {
		header: getCourseTxCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: 1,
		sortable: true,
	}, {
		header: getCourseTxCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex: 1,
		sortable: false,
	}, {
		header: getHostelTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		flex: 1
	}, {
		header: getCommonTranslation('DATE'),
		dataIndex: 'punchDate',
		flex: 1,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return dateRender(value);
			}
			else{
				return '';
			}
		}
	}, {
		header: getCommonTranslation('CALENDAR_DAY'),
		dataIndex: 'punchDay',
		flex: 1,
		sortable: true,
	}, {
		header: getCBTranslation('attendance_machine_log_punchTime'),
		dataIndex: 'punchTime',
		flex: 1,
		sortable: true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return timeRender(value);
			}
			else{
				return '';
			}
		}
	}, {
		header: getCommonTranslation('BMI_MACHINE_ID'),
		dataIndex: 'machineCode',
		flex: 1
	}],
});