/**
 * @author Ramkrishna  Yadav
 */
Ext.define('Academia.view.hrm.report.HRMAttendanceStatusReportGrid', {
   extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmattendancestatusreportgrid',
    store: 'hrm.report.HRMAttendanceStatusReportGridStore',
    title: getPersonModuleTranslation('HRM_EMPLOYEE_ATTENDANCE_STATUS'),
    border: true,
    refreshStoreData: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.report.HRMAttendanceStatusReportGridStore', 
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getPersonModuleTranslation('HRM_EMP_ID'),
        dataIndex: 'empCode',
        flex: 1,
        sortable: false
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'empPrintName',
        flex: 1,
        sortable: false
    }, {
        header: getCommonTranslation('GENDER'),
        dataIndex: 'genderCSM',
        flex: 1,
        sortable: true,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return getCommonTranslation(value);
        	}
        	else{
        		return '';
        	}
        }
    }, {
        header: getEnquiryTranslation('DEPARTMENT'),
        dataIndex: 'deptName',
        flex: 1,
        sortable: false,
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designation',
        flex: 1
    }, {
        header: getCommonTranslation('GROUP_TYPE'),
        dataIndex: 'userGroup',
       /* renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return getCommonTranslation('FACULTY');
        	}
        	else{
        		return '';
        	}
        },*/
        flex: 1
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'attendanceDate',
        flex: 1,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return dateRender(value);
        	}
        	else{
        		return '';
        	}
        }
    }, {
        header: getCommonTranslation('CALENDAR_DAY'),
        dataIndex: 'day',
        flex: 1,
        sortable: true,
    }, {
        header: getCommonTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return value;
        	}
        	else{
        		return '';
        	}
        }
    }],
});