/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.LeaveTypesGrid', {
	 //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leavetypesgrid',
    store: 'leavemanagement.LeaveTypeGridStore',
    border: true,
    autoScroll: false,
    refreshStoreData:true,
    frame:false,
//    selType:'checkboxmodel',
    title:getCommonTranslation('LEAVE_TYPES'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
//		 showHeaderCheckbox: true,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false,
	     //injectCheckbox:1
   },
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'leavetypefilter':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'leavemanagement.LeaveTypeGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    
   }],
    columns: [{
    	header: getExaminationTranslation('S_NO'),
    	xtype: 'rownumberer',
        sortable: false,
        align:'center',
        flex:.2,
        locked: false,
        hidden:true
    },{
        header:getCommonTranslation('LEAVE_CODE'),
        dataIndex: 'leaveCode',
        flex:.4,
        sortable:true
    }, {
        header: getCommonTranslation('LEAVE_TYPE'),
        dataIndex: 'leaveType',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('ELIGIBILITY_CRITERIA'),
        dataIndex: 'eligibilityCriteria',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                        
		}
    }, {
        header: getCommonTranslation('VALID_FROM'),
        dataIndex: 'validFrom',
        flex:.3,
        sortable: true,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
    },{
        header: getCommonTranslation('STATUS'),
        dataIndex: 'leaveStatus',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.leaveStatus == "ACTIVE"){
					return "<span style=\'color:green\'>Active</span>";
				} else {
					return "<span style=\'color:red\'>In Active</span>";
				}
			}                        
		}
    }]
});