/**
 * 
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMLeaveRequestPendingActionDetailWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.lmleaverequestpendingactiondetailwin',
    title: getCommonTranslation('LM_LEAVE_REQUEST_ACTION'),
    modal: true,
    resizable: true,
    autoScroll: true,
    maxHeight: '65%',
	width: '60%',
	//frame: true,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		height:'30px',
		items: [{
			xtype: 'displayfield',
			id: 'approvalFlowId',
			itemId: 'approvalFlowItemId',
			name: 'approvalFlowId',
			fieldLabel: getCommonTranslation('LM_APPROVAL_FLOW'),
			labelAlign: 'left',
			width: 226,
			labelWidth: 90
		}]
	},{
        xtype: 'grid',
        title: getCommonTranslation('LM_REQUEST_TIMELINE'),
        store: 'leavemanagement.leaveapprovalsetup.LMLeaveRequestDetailStore',
        frame: false,
        border: true,
        autoScroll: false,
        itemId: 'lmLeaveRequestPendingActionDetailGrid',
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        style: {
        	margin: '8px 0px'
        },
        columns: [{
            header: getCommonTranslation('LM_LEVEL'),
            dataIndex: 'approverLevelId',
            flex: 1,
        },{
            header: getCommonTranslation('LM_APPROVER'),
            dataIndex: 'reqApprover',
            flex: 1,
            renderer: function(value) {
                if (!isNullOrEmpty(value)) {
                    return value.value;
                } else {
                    return "";
                }
            }
        },{
            header: getCommonTranslation('LM_COMMENTS'),
            dataIndex: 'comment',
            flex: 1,
        },{
            header: getCommonTranslation('LM_REQUEST_RECIEVED_DATE'),
            dataIndex: 'requestReceivedDate',
            flex: 1,
            renderer: function(value) {
                if (!isNullOrEmpty(value)) {
                    return dateRender(value);
                } else {
                    return "";
                }
            }
        },{
            header: getCommonTranslation('LM_UPDATED_ON'),
            dataIndex: 'actionDate',
            flex: 1,
            renderer: function(value) {
                if (!isNullOrEmpty(value)) {
                    return dateRender(value);
                } else {
                    return "";
                }
            }
        },{
            header: getCommonTranslation('LM_ACTION'),
            dataIndex: 'status',
            flex: 1,
            renderer: function(value) {
            	if(value == 'PENDING') {
            		return getCommonTranslation('PENDING')
            	}else if (value == 'APPROVED') {
            		return getCommonTranslation('APPROVED')
            	}else if (value == 'REJECT') {
            		return getCommonTranslation('REJECTED')
            	}else if (value == 'WITHDRAWN') {
            		return getCommonTranslation('WITHDRAWN')
            	}else if (value == 'ESCALATED') {
            		return getCommonTranslation('ESCALATED')
            	}
            	return value;
            }
        }]
    },{
        xtype: 'form',
        itemId: 'lmLeaveRPAFormItemId',
        style: {
        	margin: '8px 0px'
        },
        items: [{
                xtype: 'textarea',
                fieldLabel: getCommonTranslation('LM_APPROVER_COMMENT'),
                labelWidth:'65px',
                height:70,
                labelAlign: 'top',
                width:'60%',
                maxLength: 225,
                name: 'rpaComment',
                itemId: 'rpaCommentItemId',
                allowBlank: true,
            
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('APPROVE'),
                itemId: 'lmApproveButtonId',
                disabled: true,
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('REJECT'),
                ui: 'CustomBtnCancel',
                itemId: 'lmRejectButtonId',
                disabled: true,
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'lmCancelButtonId',
                hidden: true,
                disabled: true,
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});