/**
 * @author Varsha Gour
 * 
 */
Ext.define('Academia.view.leavemanagement.report.LMLeaveApprovalFlowReportFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lmleaveapprovalflowreportfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            itemId: 'empItemId',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
            //store: 'criteriabuilder.userquicksearch.QuickSearchName',
            //hidden: true,
            //id:'empId',
			name: 'empId',
            fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
            queryParam:'name',
			displayField: 'valueCode',
			valueField: 'id',
			minChars: 3,
			typeAhead: false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents: 'true',
			hideTrigger: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'customcombobox',
            itemId: 'cmbDepartmentItemId',
            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
            valueField: 'id',
            displayField: 'name',        
            name: 'DEPARTMENT',
            editable: false,
            triggerAcation: 'all',
            fourceSelection: true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.departmentFilterStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
    		xtype: 'customcombobox',
    		itemId:'designationItemId',
    		fieldLabel: getPersonModuleTranslation('DESIGNATION'),
    		store: 'common.DesignationTypeStore',
    		valueField: 'id',
    		displayField: 'value',        
    		name : 'DESIGNATION_ID',
    		editable: false,
    		triggerAcation: 'all',
    		fourceSelection: true,
    	},{
            xtype: 'statusCombo',
            name: 'STATUS',
            itemId:'statusComboItemId',
            value:true
        }]
    }, {

		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchLMLeaveApprovalFlowReportFilterItemId',
			disabled:true,
			// buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetLMLeaveApprovalFlowReportFilterItemId',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
    }]
});