/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.sanctionleave.AddSanctionSetting', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.addsanctionsetting',
	autoScroll: false,
    modal: true,
    autoScroll:false,
    frame:true,
    title:getCommonTranslation('ADD_ELIGIBILITY_SETTINGS'),
//	plain: true,
    items : [{
    	xtype:'form',
    	plugins:"formlabelrequired",
    	items : [{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
			    xtype: 'hidden',
			    itemId:'idItemId',
			    name: 'id'
		    },{
    			xtype: 'textfield',
    			name: 'sanctionCode',
    			fieldLabel:getCommonTranslation('SANCTION_CODE'),
    			allowBlank:false
    		},{
				xtype: 'numberfield',
				name: 'minApplDays',
				itemId: 'minApplDaysItemId',
				fieldLabel: getCommonTranslation('MINIMUM_APPLICATION_DAYS'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype: 'numberfield',
				name: 'maxApplDays',
				itemId: 'maxApplDaysItemId',
				fieldLabel: getCommonTranslation('MAX_APPLICATION_DAYS'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
            	xtype: 'customcombobox',
                name: 'maxSanctionPeriod',
                itemId:'maxSanctionPeriodItemId',
                store:'leavemanagement.LeavePeriodEnumStore',
                displayField:'value',
                valueField:'id',
                allowBlank:false,
                forceSelection:true,
                editable:false,
                typeAhead:true,
                fieldLabel:getCommonTranslation('MAX_SANCTIONING_PERIOD'),
            },{
				xtype: 'numberfield',
				name: 'maxTimeToSanction',
				fieldLabel: getCommonTranslation('MAX_TIMES_TO_SANCTION'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype: 'numberfield',
				name: 'maxLeaveToSanction',
				fieldLabel: getCommonTranslation('MAX_LEAVE_TO_SANCTION'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype: 'numberfield',
				name: 'daysForAdvanceAppl',
				fieldLabel: getCommonTranslation('DAYS_TO_ADVANCE_APPLICATION'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype: 'numberfield',
				name: 'daysBeforeEvent',
				fieldLabel: getCommonTranslation('DAYS_BEFORE_EVENT'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			},{
				xtype: 'numberfield',
				name: 'daysAfterEvent',
				fieldLabel: getCommonTranslation('DAYS_AFTER_EVENT'),
				minValue : 0,
				allowBlank:false,
				maxValue:100,
				allowDecimal:true
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('HOLIDAY_CHECK'),
				itemId: 'holidayCheckId',
				name:'holidayCheck',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isholidayCheck', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isholidayCheck', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype      : 'radiogroup',
				fieldLabel : getCommonTranslation('COMBINABLE'),
				itemId: 'combinableId',
				name:'combinable',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'isCombinable', 
					inputValue: true,
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'isCombinable', 
					inputValue: false,
					checked:true
				}]
			}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'multiselectcombofield',
    			name: 'combinWith',
    			itemId:'combinWithItemId',
    			store:'leavemanagement.LeaveTypeStore',
    			displayField:'value',
    			width: 460,
    			valueField:'id',
    			allowBlank:false,
    			forceSelection:true,
    			editable:false,
    			hidden:true,
    			typeAhead:true,
    			fieldLabel:getCommonTranslation('COMBINE_WITH'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			}
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
            	xtype: 'customcombobox',
                name: 'HRLeaveType',
                itemId:'HRLeaveTypeItemId',
                store:'leavemanagement.LeaveTypeStore',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
                typeAhead:true,
                disabled:true,
                fieldLabel:getCommonTranslation('OTHER_SANCTION_CRITERIA'),
            }]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		cls:'windowBtnPos',
    		items:[{
    			xtype: 'button',
    			itemId:'saveBtn',
    			text: getCommonTranslation('SUBMIT'),
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind:true
    		},{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
    	}]
    }]
	});