/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.leavemanagement.sanctionleave.SanctionSettingsGrid', {
	 //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.sanctionsettingsgrid',
    store: 'leavemanagement.sanctionleave.SanctionSettingGridStore',
    border: true,
    autoScroll: false,
    frame:false,
//    selType:'checkboxmodel',
    title:getCommonTranslation('SANCTION_SETTING_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
//		 showHeaderCheckbox: true,
	     checkOnly : true, 
	     allowDeselect: false,
	
   },
   headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sanctionsettingfilter':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'leavemanagement.sanctionleave.SanctionSettingGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    
	   },{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnApplyToItemId',
			tooltip: getExaminationTranslation('APPLY_TO'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('APPLY_TO'),
			style:{
//					marginLeft:'5px',
					marginRight:'10px'
			}
		}]
	}],
    columns: [{
    	header: getExaminationTranslation('S_NO'),
    	xtype: 'rownumberer',
        sortable: false,
        align:'center',
        flex:.2,
        locked: false,
        hidden:true
    },{
        header:getCommonTranslation('SANCTION_CODE'),
        dataIndex: 'sanctioningCode',
        flex:.4,
        sortable:true
    }, {
        header: getCommonTranslation('HOLIDAY_CHECK'),
        dataIndex: 'isHolidayCheck',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value){
					return "<span style=\'color:green\'>Yes</span>";
				} else {
					return "<span style=\'color:red\'>No</span>";
				}
			} else {
				return "-";
			}   	                     
        }
    }, {
        header: getCommonTranslation('COMBINABLE'),
        dataIndex: 'isCombinable',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value){
					return "<span style=\'color:green\'>Yes</span>";
				} else {
					return "<span style=\'color:red\'>No</span>";
				}
			} else {
				return "-";
			}   	                     
        }
    }, {
        header: getCommonTranslation('MINIMUM_APPLICATION_DAYS'),
        dataIndex: 'minApplicationDays',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return "-";
			}                   
        }
    },{
        header: getCommonTranslation('MAX_APPLICATION_DAYS'),
        dataIndex: 'maxApplicationDays',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return "-";
			}                   
        }
    }, {
        header: getCommonTranslation('SERVICE_BASED'),
        dataIndex: 'camelCaseValue',
        flex:.3,
        sortable: true
    }]
});