/**
 * @author Soham.Gurjar
 */
var lcdServiceGridStore = Ext.create('Academia.store.lecturercostingdefinition.LCDServiceGridStore');
Ext.define('Academia.view.lecturerCostingDefinition.LecturerCostingServiceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.lecturercostingservicegrid',
	store : lcdServiceGridStore,
	border: true,
	title: getCommonTranslation('LECTURER_COSTING_LIST'),
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId : 'custompagingtoolbarId',
			plugins:['pagesize'],
			store : lcdServiceGridStore,
			emptyMsg :getCourseTxCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar : [ {xtype : 'button',
		text:getCommonTranslation('ADD_COST'),
		itemId:'addServiceCostingBtn',
		disabled:true}
	],
	columns : [{
		header : getProgramandcourseTranslation('SERVICE'),
		dataIndex : 'serviceName',
		flex : 0.1
	},	{header : getCommonTranslation('SERVICE_COORDINATOR'),
		dataIndex : 'coordinatorName',
		flex : 0.15}, 
		{
			header : getCommonTranslation('COST_DETAILS'),
			dataIndex : 'costDetails',
			flex : 0.1,
			align: 'center',
			renderer:function(value,meta,record){
				if(record.data.isCostDtlsPresent)
				return '<a href=#>'+getProgramandcourseTranslation('VIEW')+'</a>'
				else
				return '-'
			}

		},
	{
		header : getProgramandcourseTranslation('MAPPING_STATUS'),
		dataIndex : 'mappingStatus',
		flex : 0.1
	}
	]

});
