/**
 * @author Soham Gurjar
 */
Ext.define('Academia.view.lecturerCostingDefinition.UploadLecturerCostingUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.uploadlecturercostinguploadform',
	autoScroll: false,
	frame: false,
	cls: 'horizontalScrollingFixed',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'uploadPeriodEnrollmentformItemId',
	},{xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [{
		xtype: 'customcombobox',
		name:'uploadType',
		itemId:'uploadTypeItemId',
		labelAlign: 'top',
		store:'lecturercostingdefinition.LecturerCostingTypeComboStore',
		fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
		valueField: 'value',
		displayField: 'name',
		allowBlank:true,
		triggerAction : 'all',
		editable: false,
		maxLength: 40,
		width: 200
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleName',
			labelAlign: 'top',
			store:'importutility.ImportLecturerCostingStore',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			readOnly:true,
			width:200,
			forceSelection:false,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						var pickerComboVal = picker.up('combobox').value;
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}}]
		
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 500,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
