/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.ActualAdmissionTargetPadmsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.actualadmissiontargetpadmsgrid',
    store: 'managetarget.ActualAdmissionTargetDetailPadmsGridStore',
    title: getAdmissionTranslation('ACTUAL_ADMISSION_TARGETS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'managetarget.ActualAdmissionTargetDetailPadmsGridStore',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	} ]
    }],
    columns: [{
        header: getCommonTranslation('APPLICATION_ID'),
        dataIndex: 'applicationCode',
        flex: 0.5,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    }, {
        header: getAdmissionTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
        		return value;
        	}
        }
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentPrintName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
					return value;
			}
        }
    }, {
        header: getCommonTranslation('DATE_OF_ADMISSION'),
        dataIndex: 'dateOfAdmission',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return dateRender(value);
        	}
        }
    },{
        header: getCommonTranslation('APPLICATION_OWNER'),
        dataIndex: 'applicationOwnerShortName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return value;
        	}
        }
    }]
});
