/**
 * @author Pravin.Surve
 * this is Quick search Form Of List Of Adhoc Events in messaging 
 */
Ext.define('Academia.view.messaging.AdhocEventsSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.adhoceventssearchform',
    frame: false,
    cls:'customSearchPanel',
    //title: getMessagingModuleTranslation('QUICK_SEARCH'),    
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_CATEGORY'),
            store: 'messaging.MessageCategoryStore',
            editable: false,
            name: 'MSG_CATAGORY',
            itemId: 'messageCategory',
            valueField: 'id',                
            displayField: 'code',
            queryMode: 'local'
        },{
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_SUBCATEGORY'),
            editable: false,
            name: 'MSG_SUB_CATAGORY',
            itemId: 'messageSubCategory',
            valueField: 'id',
            queryMode: 'local',
            displayField: 'code',
            listeners: {
            	render: function(combo){
            		var store = Ext.create('Academia.store.messaging.MessageSubCategoryStore');
            		combo.bindStore(store);
            	}
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getMessagingModuleTranslation('REVIEW_STATUS'),            
            store: 'messaging.TemplateStatusStore',
            editable: false,
            name: 'REVIEW_STATUS_CODE',
            itemId: 'reviewStatusCombo',            
            valueField: 'name',
            queryMode: 'local',
            displayField: 'value',
            value:'All'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_NAME'),
            name: 'MESSAGE_NAME'
        },{
            xtype: 'textfield',
            fieldLabel: getMessagingModuleTranslation('MESSAGE_CODE'),
            name: 'MESSAGE_CODE'
        },{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('MESSAGE_STATUS'),
            store: 'messaging.MessageStatusStore',
            name: 'MESSAGE_STATUS',
            editable: false,
            itemId: 'messageStatusCombo',            
            valueField: 'name',
            queryMode: 'local',
            displayField: 'value',
            value:'All'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'FROM_DATE',
            itemId: 'msgFromDateId',
            vtype: 'daterange',
            editable: false,
            fieldLabel: getCommonTranslation('FROM_DATE'),
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            },
        	endDateField: 'msgToDateId',
        	vtype: 'daterange'
        }, {
            xtype: 'datefield',
            name: 'TO_DATE',
            itemId: 'msgToDateId',
            vtype: 'daterange',
            editable: false,
            fieldLabel: getCommonTranslation('TO_DATE'),
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            },
        	startDateField: 'msgFromDateId',
        	vtype: 'daterange'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style :{
        	marginTop : '16px',
        	marginLeft : '-2px'
        },
        items: [{
            xtype: 'button',
            text: getMessagingModuleTranslation('SEARCH'),
            itemId: 'adhocEventFindButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getMessagingModuleTranslation('CLEAR_SEARCH'),
            itemId: 'adhocEventClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});